package Scheduler::Data::PlainText::Imported;
@ISA = qw|Scheduler::Data::PlainText|;

use strict;
use warnings;
use Carp;

use Scheduler::Data::PlainText;
use File::Find;
use File::stat;

sub new{
  shift;
  my $t = {@_};
  return bless {@_};
}
sub getIDList{
  my $oS = shift;
  my @asResult = ();
  $oS->optimize;
   find(sub{
	 return if $_ eq '.';
	 push(@asResult,$_);
       },$oS->{path}.'imported');
  return @asResult;
}
sub itExpires($$$){
  my $oS = shift;
  my $sID = shift;
  my $nPosLevel = shift || 1;
  my $nPosDiv = (1/2) ** $nPosLevel;
  my $nSeconds = shift || $oS->{refresh_interval};
  $nSeconds *= $nPosDiv;
  return 1 if(!-e $oS->{path}.'imported/'.$sID);
  my $nLastAccessTime = stat($oS->{path}.'imported/'.$sID)->mtime;
  if(time-$nLastAccessTime > $nSeconds){
    return 0;
  }
  return 1;
}
sub optimize(){
  my $oS = shift;
  $oS->initialize;
}
sub initialize{
  my $oS = shift;
  $oS->optimizePath;
}
sub makeDir{
  my $oS = shift;
  $oS->makeDirectory($oS->path.'imported/');
}
sub delScheByID($){
  my $oS = shift;
  my $sID = shift;
  return if !defined $sID;
  $oS->optimizePath;
  unlink($oS->path.'imported/'.$sID);
}
sub getScheByID($){
  my $oS = shift;
  my $sID = shift;
  $oS->optimizePath;
  if(-e $oS->path.'imported/'.$sID){
    return $oS->SUPER::getScheByID($sID);
  }else{
    return undef;
  }
}
sub setSche($$){
  my $oS = shift;
  $oS->optimize;
  my $sID = shift;
  my $isImported = shift;
  print STDERR "Imported : $sID is $isImported\n";
  return if !defined $sID or $sID eq '' or !$isImported;
  my $oSche = $oS->getScheByID($sID);
  my $sNewFileName = $oS->path.'imported'."/$sID";
  symlink($oS->path.'whole/'.$sID,$sNewFileName);
}

1;
