package Scheduler::Data::base;

use strict;
use warnings;
use Carp;

use DynamicHTTP;
use Encode qw|decode|;
use Scheduler::Parser::Feed;

sub reload{
  my $oS = shift;
  my $oSche = shift;
  return if !defined $oSche;
  my $sLatestURI = $oSche->uris->[0];
  my @asURIs = @{$oSche->uris};
  shift @asURIs;
  foreach(@asURIs){
    my $isLoaded = $oS->loadScheFromURI($_,$sLatestURI);
    last if $isLoaded == 1;
  }
}
sub loadScheFromURI($$){
  my $oS = shift;
  my $sURI = shift;
  my $sLatestURI = shift;
  my $oDH = new DynamicHTTP(temp_dir=>$oS->{path});
  my $sFeed = $oDH->get($sURI);
  return 0 if !defined $sFeed or $sFeed eq '';
  $sFeed = decode('utf-8',$sFeed);
  my $oFeed = Scheduler::Parser::Feed->objFromDocstring($sFeed);
  $oFeed->sche->addNewURI($sLatestURI);
  $oS->updateSche($oFeed->sche->id,$oFeed->sche,0);
  return 1;
}

1;
