package Scheduler::Parser::Time;
@ISA = qw|Scheduler::Parser::base|;

use strict;
use warnings;
use Carp;

use Scheduler::Parser::base;
use Scheduler::Schema::Time;
use Scheduler::Schema::TimeOptimized;

sub obj($$){
  shift;
  my $oTime = new Scheduler::Schema::Time;
  my $oRoot = shift;
  my $oDocument = shift;
  my @a = $oRoot->getChildNodes;
  foreach(@a){
    if($_->nodeName eq 'begin'){
      $oTime->setBegin(new Scheduler::Schema::TimeOptimized($_->firstChild->nodeValue));
    }elsif($_->nodeName eq 'end'){
      $oTime->setEnd(new Scheduler::Schema::TimeOptimized($_->firstChild->nodeValue));
    }elsif($_->nodeName eq 'accuracy'){
      $oTime->setAccuracy($_->firstChild->nodeValue);
    }
  }
  return $oTime;
}
sub element($$){
  shift;
  my $oTime = shift;
  my $oDocument = shift;
  my $oRoot = $oDocument->createElement('time');
  $oRoot->appendTextChild('begin',$oTime->begin->ISO8601) if defined $oTime->begin;
  $oRoot->appendTextChild('end',$oTime->end->ISO8601) if defined $oTime->end;
  $oRoot->appendTextChild('accuracy',$oTime->accuracy);
  return $oRoot;
}

1;
