package Scheduler::Schema::Changeable;

use strict;
use warnings;
use Carp;

use Scheduler::Schema::Author;
use Scheduler::Schema::Time;
use Scheduler::Schema::Location;

sub new(){
  shift;
  return bless {
		modified => undef,
		title => undef,
		subtitle => undef,
		summary => undef,
		contents => undef,
		time => undef,
		locations => [],
		class => 'confidential',
		authors => [],
		reloadinterval => 600,
		generator => undef,
	       };
}
sub type{'full';}

sub modified{$_[0]->{modified};}
sub title{$_[0]->{title};}
sub subtitle{$_[0]->{subtitle};}
sub summary{$_[0]->{summary};}
sub content{$_[0]->{content};}
sub locations{
  if(defined $_[1]){
    return $_[0]->{locations}->[$_[1]];
  }
  $_[0]->{locations};
}
sub location{
  my $nI = $_[1] || 0;
  $_[0]->locations($nI);
}
sub time{$_[0]->{time};}
sub class{$_[0]->{class};}
sub authors{
  if(defined $_[1]){
    return $_[0]->{authors}->[$_[1]];
  }
  $_[0]->{authors};
}
sub author{
  my $nI = $_[1] || 0;
  $_[0]->authors($nI);
}
sub reloadinterval{$_[0]->{reloadinterval};}
sub generator{$_[0]->{generator};}
sub setModified{$_[0]->{modified} = $_[1];}
sub setTitle{$_[0]->{title} = $_[1];}
sub setSubtitle{$_[0]->{subtitle} = $_[1];}
sub setSummary{$_[0]->{summary} = $_[1];}
sub setContent{$_[0]->{content} = $_[1];}
sub setLocation{$_[0]->{locations} = [$_[1]];}
sub addLocation{push(@{$_[0]->{locations}},$_[1]);}
sub setTime{$_[0]->{time} = $_[1];}
sub setClass{$_[0]->{class} = $_[1];}
sub setAuthor{$_[0]->{authors} = [$_[1]];}
sub addAuthor{push(@{$_[0]->{authors}},$_[1]);}
sub setReloadinterval{$_[0]->{reloadinterval} = $_[1];}
sub setGenerator{$_[0]->{generator} = $_[1];}

sub clone{
  my $oS = shift;
  my $oSNew = new Scheduler::Schema::Changeable;
  $oSNew->setModified($oS->modified->clone);
  $oSNew->setTitle($oS->title);
  $oSNew->setSubtitle($oS->subtitle);
  $oSNew->setSummary($oS->summary);
  $oSNew->setContent($oS->content->clone) if defined $oS->content;
  $oSNew->addLocation($_->clone) for @{$oS->locations};
  $oSNew->setTime($oS->time->clone);
  $oSNew->setClass($oS->class);
  $oSNew->addAuthor($_->clone) for @{$oS->authors};
  $oSNew->setReloadinterval($oS->reloadinterval);
  $oSNew->setGenerator($oS->generator);
  return $oSNew;
}

1;
