package xor.main;

import xor.sche.*;
import java.util.*;

public class DBSetEvent extends EventObject{
    private DBSetEnum m_sType;
    private SelectionMap m_oQC;
    private PaletteEnum m_sPE;
    
    public DBSetEvent(Object _oS,DBSetEnum _sType,SelectionMap _oQC){
	super(_oS);
	initCopy(_sType,_oQC);
    }
    public DBSetEvent(Object _oS,DBSetEnum _sType){
	super(_oS);
	initCopy(_sType,new SelectionMap());
    }
    public DBSetEvent(Object _oS,DBSetEnum _sType,PaletteEnum _sPE){
	super(_oS);
	initCopy(_sType,new SelectionMap());
	m_sPE = _sPE;
    }
    public DBSetEvent(Object _oS,DBSetEnum _sType,Sche _oSche){
	super(_oS);
	initCopy(_sType,new SelectionMap(_oSche));
	m_oQC.addScheFor(_oSche);
    }
    private void initCopy(DBSetEnum _sType,SelectionMap _oQC){
	m_sType = _sType;
	m_oQC = _oQC;
    }
    public final DBSetEnum getType(){
	return m_sType;
    }
    public final SelectionMap getSelectionMap(){
	return m_oQC;
    }
    public final PaletteEnum getPaletteType(){
	return m_sPE;
    }
    public String toString(){
	return getClass().getName()+"[source="+getSource()+",type="+m_sType+",querycallers="+m_oQC.toString()+"]";
    }
}
