package xor.main;

import java.net.*;
import java.io.*;
import java.util.*;

public class ScheAdderSocket implements Runnable{
    static private int s_nPortNumber = 51028;
    private Kernel m_oKernel;
    private Map<String,Integer> m_oPortMap;

    ScheAdderSocket(Kernel _oK){
	m_oKernel = _oK;
	m_oPortMap = new HashMap<String,Integer>();
    }
    public void run(){
	m_oKernel.getLogger().config("Starting Sche adder socket.");
	try{
	    ServerSocket _oSSocket = new ServerSocket(s_nPortNumber);
	    m_oKernel.getLogger().fine("Sche adder socket is listening at port : "+s_nPortNumber);
	    while(true){
		ConnectionToClient _oCTC = new ConnectionToClient(_oSSocket.accept());
		Thread _oCTCThread = new Thread(_oCTC);
		_oCTC.setThread(_oCTCThread);
		_oCTCThread.start();
	    }
	}catch(java.net.BindException e){
	    m_oKernel.getLogger().warning("Cannot open socket. Maybe another process is running. Shut down.");
	    m_oKernel.exit();
	}catch(Exception e){
	    e.printStackTrace();
	}
    }
    class ConnectionToClient implements Runnable{
	private Socket m_oS;
	private Thread m_oThis;

	ConnectionToClient(Socket _oS){
	    m_oS = _oS;
	    m_oThis = null;
	}
	public void setThread(Thread _oT){
	    m_oThis = _oT;
	}
	public void run(){
	    m_oKernel.getLogger().config("Connection start.");
	    String _sFilePath = "";
	    try{
		BufferedReader _oIn = new BufferedReader(new InputStreamReader(m_oS.getInputStream()));
		_sFilePath = _oIn.readLine();
		_oIn.close();
		DBSet _oDBSet = null;
		if(_sFilePath == null){
		    m_oS.close();
		    return;
		}
		while(_oDBSet == null){
		    _oDBSet = m_oKernel.getDBSet();
		    m_oThis.sleep(200);
		}		
		m_oKernel.execQuery("import -f "+_sFilePath);
	    }catch(Exception e){
	    }finally{
		try{
		    m_oS.close();
		}catch(Exception e){
		}
	    }
	}
    }
}
