package xor.main;

import java.io.*;
import java.util.*;

abstract public class TextFileLoader{
    protected String m_sFileName;
    protected Kernel m_oKernel;
    protected boolean m_isFileLoaded;

    TextFileLoader(Kernel _oKernel,String _sFileName){
	m_oKernel = _oKernel;
	m_sFileName = _sFileName;
	m_isFileLoaded = false;
    }
    synchronized public void suicide(){
	File _oFile = new File(m_sFileName);
	if(_oFile.exists()){
	    boolean _isDeleted = _oFile.delete();
	    if(_isDeleted){
		m_oKernel.getLogger().config("Deleted "+m_sFileName);
	    }else{
		m_oKernel.getLogger().severe("Cannot delete "+m_sFileName);
	    }
	}
    }
    synchronized protected void checkFiles(){
	File _oFile = new File(m_sFileName);
	File _oParentDir = _oFile.getParentFile();
	try{
	    if(_oParentDir.exists() && !_oParentDir.isDirectory()){
		m_oKernel.getLogger().warning("Path "+_oParentDir.getCanonicalPath()+" was not a directory.");
		boolean _isDeleted = _oParentDir.delete();
		if(!_isDeleted){
		    m_oKernel.getLogger().severe("Path "+_oParentDir.getCanonicalPath()+" cannot be deleted!");
		}
	    }
	    if(!_oParentDir.exists()){
		m_oKernel.getLogger().warning("Cannot find directory : "+_oParentDir.getCanonicalPath());
		_oParentDir.mkdirs();
	    }
	    if(!_oFile.exists()){
		_oFile.createNewFile();
	    }
	}catch(IOException e){
	    e.printStackTrace();
	}
    }
}
