package xor.main;

import java.io.*;
import java.util.*;

public class TextListFileLoader extends TextFileLoader{
    private AbstractList<String> m_asList;

    public TextListFileLoader(Kernel _oKernel,String _sFileName){
	super(_oKernel,_sFileName);
	m_asList = new Vector<String>();
    }
    public void add(String _sNewElement){
	if(!m_isFileLoaded){
	    load();
	}
	m_asList.add(_sNewElement);
    }
    public Iterator iterator(){
	if(!m_isFileLoaded){
	    load();
	}
	return m_asList.iterator();
    }
    public void clear(){
	if(!m_isFileLoaded){
	    load();
	}
	m_asList.clear();
    }
    public String get(int _nPos){
	if(!m_isFileLoaded){
	    load();
	}
	return m_asList.get(_nPos);
    }
    public void searchAndDestroy(String _sTargetElement){
	if(!m_isFileLoaded){
	    load();
	}
	int _nFoundPos = m_asList.indexOf(_sTargetElement);
	if(_nFoundPos == -1){
	    return;
	}
	m_asList.remove(_nFoundPos);
    }
    synchronized private void load(){
	checkFiles();
	File _oFile = new File(m_sFileName);
	try{
	    BufferedReader _oBL = new BufferedReader(new InputStreamReader(new FileInputStream(m_sFileName),"UTF-8"));
	    String _sLine;
	    while((_sLine = _oBL.readLine()) != null){
		m_asList.add(_sLine);
	    }
	}catch(Exception e){
	    e.printStackTrace();
	}
	m_oKernel.getLogger().fine("Loaded "+m_sFileName);
    }
    synchronized public void update(){
	checkFiles();
	File _oFile = new File(m_sFileName);
	try{
	    BufferedWriter _oFW = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(m_sFileName),"UTF-8"));
	    Iterator _i = m_asList.iterator();
	    while(_i.hasNext()){
		String _sElement = (String)_i.next();
		_oFW.write(_sElement);
		_oFW.write("\n");
	    }
	}catch(Exception e){
	    e.printStackTrace();
	}
	m_oKernel.getLogger().fine("Updated file "+m_sFileName);
    }
}
