package xor.main.dbloader;

import java.util.*;
import java.lang.*;
import java.util.logging.*;
import java.io.*;
import xor.sche.*;
import xor.main.*;

public class XML extends Abstract{
    private String m_sDirPath;
    private Kernel m_oKernel;
    private TextConfigFileLoader m_oTCFL;
    private Set<XMLFileLoader> m_aoXFLs;
    private boolean m_isDeleted;
    private String m_sStatus;
    private boolean m_isLoading;
    
    public XML(DBSet _oDBSet,TextConfigFileLoader _oTCFL,Kernel _oKernel){
	super(_oDBSet);
	m_oKernel = _oKernel;
	m_sDirPath = _oTCFL.getOne("DIRECTORY");
	m_oTCFL = _oTCFL;
	if(m_sDirPath != null){
	    loadFor(m_sDirPath);
	}
	m_aoXFLs = null;
	m_isDeleted = false;
	m_sStatus = null;
	m_isLoading = false;
    }
    private void loadFor(String _sDirPath){
	m_isLoading = true;
	m_aoXFLs = new HashSet<XMLFileLoader>();
	File _oDir = new File(_sDirPath);
	if(!_oDir.exists()){
	    m_oKernel.getLogger().warning("Cannot find directory : "+_sDirPath);
	    _oDir.mkdirs();
	}
	Thread _oT = new Thread(new DirLoader());
	_oT.start();
    }
    class DirLoader implements Runnable{
	synchronized public void run(){
	    m_aoXFLs = new HashSet<XMLFileLoader>();
	    m_sStatus = "load";
	    doFor("canvas");
	    doFor("palette");
	}
	private void doFor(String _sType){
	    File _oDir = new File(m_sDirPath+"/"+_sType);
	    if(!_oDir.exists()){
		m_oKernel.getLogger().warning("Cannot find directory : "+m_sDirPath+"/"+_sType);
		_oDir.mkdirs();
		return;
	    }
	    String _asFiles[] = _oDir.list();
	    for(int i=0;i<_asFiles.length;i++){
		File _oLoadingFile = new File(_oDir.getPath()+"/"+_asFiles[i]);
		XMLFileLoader _oXFL = new XMLFileLoader(m_oDBSet,_oLoadingFile,_sType,m_oKernel);
		Thread _oT = new Thread(_oXFL);
		_oT.start();
		if(m_aoXFLs == null){
		    m_aoXFLs = new HashSet<XMLFileLoader>();
		}
		m_aoXFLs.add(_oXFL);
	    }
	}
    }
    public void suicide(){
	if(m_sDirPath != null){
	    suicideFor("palette");
	    suicideFor("canvas");
	    File _oDir = new File(m_sDirPath);
	    _oDir.delete();
	    deleteLog(_oDir);
	    m_oTCFL.suicide();
	    m_sDirPath = null;
	}
    }
    private void suicideFor(String _sSuffix){
	File _oDir = new File(m_sDirPath+"/"+_sSuffix);
	File[] _oSubFiles = _oDir.listFiles();
	int _nSize = _oSubFiles.length;
	int _nI = 0;
	for(;_nI<_nSize;_nI++){
	    deleteLog(_oSubFiles[_nI]);
	    _oSubFiles[_nI].delete();
	}
	_oDir.delete();
	deleteLog(_oDir);
    }
    private void deleteLog(File _oF){
	m_oKernel.getLogger().config("Deleted "+_oF.getAbsolutePath());
    }
    public void save(DB _oDB){
	m_oKernel.getLogger().config("Save begin.");
	m_aoXFLs = new HashSet<XMLFileLoader>();
	m_sStatus = "save";
	saveFor(_oDB.getCanvas(),"canvas");
	saveFor(_oDB.getPalette(),"palette");
    }
    private void saveFor(DBBuffer _oDBB,String _sType){
	m_isDeleted = false;
	File _oBefore = new File(m_sDirPath+"/"+_sType+"/");
	Set<String> _asCanoPaths = new HashSet<String>();
	File[] _asCanoPathsTmp = _oBefore.listFiles();
	int _nI;
	for(_nI=0;_nI<_asCanoPathsTmp.length;_nI++){
	    try{
		_asCanoPaths.add(_asCanoPathsTmp[_nI].getCanonicalPath());
	    }catch(IOException e){e.printStackTrace();}
	}
	Iterator _i = _oDBB.getIDs().iterator();
	while(_i.hasNext()){
	    String _sID = (String)_i.next();
	    File _oF = new File(m_sDirPath+"/"+_sType+"/"+_sID);
	    try{
		_asCanoPaths.remove(_oF.getCanonicalPath());
		_oF.createNewFile();
	    }catch(Exception e){
		e.printStackTrace();
	    }
	    Sche _oS = _oDBB.getScheWith(_sID);
	    XMLFileLoader _oXFL = new XMLFileLoader(m_oDBSet,_oF,_sType,m_oKernel,_oS);
	    m_aoXFLs.add(_oXFL);
	    Thread _oT = new Thread(_oXFL);
	    _oT.start();
	}
	_i = _asCanoPaths.iterator();
	while(_i.hasNext()){
	    String _sCanoPath = (String)_i.next();
	    File _oF = new File(_sCanoPath);
	    _oF.delete();
	    m_oKernel.getLogger().fine("Deleted File : "+_sCanoPath);
	}
	m_isDeleted = true;
    }
    public boolean isSavable(){
	return (new File(m_sDirPath+"/") != null);
    }
    public String dbtype(){
	return "plaintext";
    }
    public String getPath(){
	return m_sDirPath;
    }
    public void setPath(String _sNewPath){
	m_sDirPath = _sNewPath;
    }
    public void update(){
	if(m_sDirPath == null){
	    return;
	}
	if(m_oTCFL == null){
	    return;
	}
	m_oTCFL.set("TYPE","plaintext");
	m_oTCFL.set("DIRECTORY",m_sDirPath);
	m_oTCFL.update();
	loadFor(m_sDirPath);
    }
    public boolean isBusy(){
	if(m_sStatus.equals("save")){
	    if(!m_isDeleted){
		return true;
	    }
	    if(m_aoXFLs == null){
		return true;
	    }
	    Iterator _i = m_aoXFLs.iterator();
	    while(_i.hasNext()){
		XMLFileLoader _oXFL = (XMLFileLoader)_i.next();
		if(_oXFL.isBusy()){
		    return true;
		}
	    }
	}else if(m_sStatus.equals("load")){
	    if(m_aoXFLs == null){
		return true;
	    }
	    Iterator _i = m_aoXFLs.iterator();
	    while(_i.hasNext()){
		XMLFileLoader _oXFL = (XMLFileLoader)_i.next();
		if(_oXFL.isBusy()){
		    return true;
		}
	    }
	}
	return false;
    }
    public String profile(){
	return "Directory path="+m_sDirPath;
    }
}
