package xor.main.schedul;

import java.util.*;
import java.io.*;
import xor.sche.*;
import xor.main.*;
import xor.main.dbloader.*;

public class Import extends Abstract{
    private boolean m_isCalled;
    private String m_sFilePath;

    public Import(Kernel _oKernel,SelectionMap _oSM){
	super(_oKernel,_oSM);
	m_isCalled = false;
	m_sFilePath = null;
    }
    protected void setMode(String _sKey,AbstractList<String> _asQueries){
	if(!m_isCalled){
	    m_isCalled = true;
	}else{
	    return;
	}
	if(_sKey.equals("u")){
	    Iterator _i = _asQueries.iterator();
	    while(_i.hasNext()){
		getURI((String)_i.next());
	    }
	}else if(_sKey.equals("f")){
	    Iterator _i = _asQueries.iterator();
	    m_sFilePath = "";
	    while(_i.hasNext()){
		String _sFile = (String)_i.next();
		if(!m_sFilePath.equals("")){
		    m_sFilePath = m_sFilePath+" ";
		}
		m_sFilePath = m_sFilePath+_sFile;
	    }
	}
    }
    protected void execWith(String _sValue,AbstractList<String> _asQueries){
	if(!m_isCalled){
	    m_isCalled = true;
	}else{
	    return;
	}
	getURI(_sValue);
	Iterator _i = _asQueries.iterator();
	while(_i.hasNext()){
	    getURI((String)_i.next());
	}
    }
    protected void doAtEnd(){
	if(m_sFilePath != null){
	    getFile(m_sFilePath);
	}
    }
    private void getURI(String _sValue){
	m_oKernel.getImporter().addURIString(_sValue);
    }
    private void getFile(String _sPath){
	File _oF = new File(_sPath);
	try{
	    m_oKernel.getLogger().fine("Loading "+_sPath);
	    Thread _oT = new Thread(new XMLFileLoader((DBSet)m_oKernel.getDBSet(),_oF,"palette",m_oKernel));
	    _oT.start();
	}catch(Exception e){
	    e.printStackTrace();
	}
    }
}
