package xor.main.swing;

import javax.swing.*;
import java.awt.*;
import java.text.*;
import java.util.*;

class CalendarControl extends JPanel{
    private int m_nRowNumber;
    private AbstractList<CalendarSocket> m_oCalendarSockets;
    protected Map<String,CalendarCell> m_oBuffer;
    private CalendarCell m_oDayTemplateCell,m_oWeekTemplateCell,m_oMonthTemplateCell;
    private boolean m_isMonthVisible;
    private GridBagLayout m_oGBL;
    private SimpleDateFormat m_oSDFForKey;
    private boolean m_isRefreshed;
    static private int s_nRefreshMilliSecs = 50;

    CalendarControl(){
	super();
	m_nRowNumber = 0;
	m_isMonthVisible = false;
	m_oGBL = new GridBagLayout();
	setLayout(m_oGBL);
	m_oSDFForKey = new SimpleDateFormat("yyyy-MM-d");
	m_oBuffer = new HashMap<String,CalendarCell>();
	runRefreshThread();
    }
    public void setMonthVisible(boolean _isVisible){
	m_isMonthVisible = _isVisible;
    }
    public void setRowNumber(int _nRows){
	if(m_nRowNumber != _nRows){
	    m_nRowNumber = _nRows;
	    if(m_oDayTemplateCell != null){
		generate();
	    }
	}
    }
    public void refresh(){
	m_isRefreshed = false;
    }
    public boolean isRefreshed(){
	return m_isRefreshed;
    }
    private void runRefreshThread(){
	Refresher _oR = new Refresher();
	Thread _oT = new Thread(_oR);
	_oR.setThread(_oT);
	_oT.start();
    }
    synchronized private void refreshNow(){
	if(!m_isRefreshed){
	    setVisible(false);
	    Iterator _i = m_oBuffer.keySet().iterator();
	    while(_i.hasNext()){
		CalendarCell _oCC = m_oBuffer.get((String)_i.next());
		if(_oCC != null){
		    _oCC.refresh();
		}
	    }
	    m_isRefreshed = true;
	    setVisible(true);
	}
    }
    class Refresher implements Runnable{
	private Thread m_oT;
	
	public void setThread(Thread _oT){
	    m_oT = _oT;
	}
	public void run(){
	    while(true){
		try{
		    m_oT.sleep(s_nRefreshMilliSecs);
		}catch(InterruptedException e){
		    e.printStackTrace();
		}
		refreshNow();
	    }
	}
    }
    public void setDayTemplateCell(CalendarCell _oCC){
	if(m_oDayTemplateCell == null){
	    m_oDayTemplateCell = _oCC;
	}
    }
    public void setWeekTemplateCell(CalendarCell _oCW){
	if(m_oWeekTemplateCell == null){
	    m_oWeekTemplateCell = _oCW;
	}
    }
    public void setMonthTemplateCell(CalendarCell _oCM){
	if(m_oMonthTemplateCell == null){
	    m_oMonthTemplateCell = _oCM;
	}
    }
    private void addCalendarSocket(JComponent _oC,int _x,int _y,int _w,int _h){
	GridBagConstraints _oGBC = new GridBagConstraints();
	_oGBC.fill = GridBagConstraints.BOTH;
	_oGBC.weightx = 100.0;
	_oGBC.weighty = 100.0;
        _oGBC.gridx = _x;
        _oGBC.gridy = _y;
        _oGBC.gridwidth = _w;
        _oGBC.gridheight = _h;
	m_oGBL.setConstraints(_oC,_oGBC);
	add(_oC);
    }
    private void addSubCalendarSocket(JComponent _oC,int _x,int _y,int _w,int _h){
	GridBagConstraints _oGBC = new GridBagConstraints();
	_oGBC.fill = GridBagConstraints.BOTH;
	_oGBC.weightx = 0.0;
	_oGBC.weighty = 100.0;
        _oGBC.gridx = _x;
        _oGBC.gridy = _y;
        _oGBC.gridwidth = _w;
        _oGBC.gridheight = _h;
	m_oGBL.setConstraints(_oC,_oGBC);
	add(_oC);
    }
    private void addHeaderSocket(JComponent _oC,int _x){
	GridBagConstraints _oGBC = new GridBagConstraints();
	_oGBC.fill = GridBagConstraints.BOTH;
        _oGBC.gridx = _x;
        _oGBC.gridy = 0;
        _oGBC.gridwidth = 1;
        _oGBC.gridheight = 1;
	m_oGBL.setConstraints(_oC,_oGBC);
	add(_oC);
    }
    synchronized public void generate(){
	generateCalendarHeader();
	generateCalendar();
    }
    private void generateCalendar(){
	Date _oDateToday = CalendarUtil.getBeginningOfThisDay(new Date());
	Date _oDateFirstOfWeek = CalendarUtil.getFirstDayOfWeek(_oDateToday);
	Date _oDateWeekIterator = CalendarUtil.getDayAfterWeeks(_oDateFirstOfWeek,-m_nRowNumber/2);
	m_oCalendarSockets = new Vector<CalendarSocket>();
	int _nRow;
	int _nMonthLength = 0;
	int _nNowMonth = -1;
	int _nMonthFirstCalled = 0;
	for(_nRow=0;_nRow<m_nRowNumber;_nRow++){
	    int _nTmpMonth = CalendarUtil.getMonth(_oDateWeekIterator);
	    if(_nMonthLength == 0){
		_nMonthLength++;
		_nNowMonth = _nTmpMonth;
	    }else{
		if(_nNowMonth == _nTmpMonth){
		    _nMonthLength++;
		}else{	
		    generateCalendarMonth(_nTmpMonth,_nMonthFirstCalled,_nMonthLength);
		    _nNowMonth = _nTmpMonth;
		    _nMonthLength = 1;
		    _nMonthFirstCalled = _nRow;
		}
	    }
	    generateCalendarRow(_nRow,_oDateWeekIterator);
	    _oDateWeekIterator = CalendarUtil.getDayAfterWeeks(_oDateWeekIterator,1);
	}
	generateCalendarMonth((_nNowMonth%12)+1,_nMonthFirstCalled,_nMonthLength);
	setVisible(true);
    }
    private void generateCalendarRow(int _nRow,Date _oDateBegin){
	int _nCol;
	Date _oDateIterator = (Date)_oDateBegin.clone();
	generateCalendarRowWeek(_nRow,_oDateBegin);
	for(_nCol=0;_nCol<7;_nCol++){
	    Date _oDTmp = (Date)_oDateIterator.clone();
	    CalendarCell _oDC = getCellFromBuffer(_oDTmp);
	    if(_oDC == null){
		_oDC = m_oDayTemplateCell.clone();
		_oDC.setDate(CalendarUtil.getBeginningOfThisDay(_oDTmp));
		addCellToBuffer(_oDC);
	    }
	    CalendarSocket _oDS = new CalendarSocket(_oDC);
	    m_oCalendarSockets.add(_oDS);
	    addCalendarSocket(_oDC,_nCol+2,_nRow+1,1,1);
	    _oDateIterator = CalendarUtil.getDayAfterDays(_oDateIterator,1);
	}
    }
    private void generateCalendarMonth(int _nMonth,int _nRow,int _nLength){
	JButton _oLab = new JButton(new Integer(_nMonth).toString());
	addSubCalendarSocket(_oLab,0,_nRow+1,1,_nLength);
    }
    private void generateCalendarRowWeek(int _nRow,Date _oDateBegin){
	CalendarCell _oCell = m_oWeekTemplateCell.clone();
	_oCell.setDate(_oDateBegin);
	addSubCalendarSocket(_oCell,1,_nRow+1,1,1);
    }
    private void generateCalendarHeader(){
	int _nW;
	SimpleDateFormat _oSDF = new SimpleDateFormat("E");
	Date _oDateIterator = CalendarUtil.getFirstDayOfWeek(new Date());
	for(_nW=0;_nW<7;_nW++){
	    JLabel _oL = new JLabel(_oSDF.format(_oDateIterator));
	    _oL.setHorizontalAlignment(SwingConstants.CENTER);
	    addHeaderSocket(_oL,_nW+2);
	    _oDateIterator = CalendarUtil.getDayAfterDays(_oDateIterator,1);
	}
    }
    private void addCellToBuffer(CalendarCell _oDC){
	Date _oD = _oDC.getDate();
	if(_oD == null){
	    return;
	}
	String _sK = m_oSDFForKey.format(_oD);
	m_oBuffer.put(_sK,_oDC);
    }
    public CalendarCell getCellFromBuffer(Date _oD){
	String _sK = m_oSDFForKey.format(_oD);
	return m_oBuffer.get(_sK);
    }
    public CalendarCell getCellAt(int _nRow,int _nColumn){
	return m_oCalendarSockets.get(numberOfCellAt(_nRow,_nColumn)).getDateCell();
    }
    public void rowDown(){
	System.out.println("DOWN");
    }
    public void rowUp(){
	System.out.println("UP");
    }
    private int numberOfCellAt(int _nRow,int _nColumn){
	return _nRow*7+_nColumn;
    }
    class CalendarSocket{
	public CalendarCell m_oDC;

	CalendarSocket(){
	    m_oDC = null;
	}
	CalendarSocket(CalendarCell _oDC){
	    setDateCell(_oDC);
	}
	public CalendarCell getDateCell(){
	    return m_oDC;
	}
	public void setDateCell(CalendarCell _oDC){
	    m_oDC = _oDC;
	}
    }
}
