package xor.main.swing;

import javax.swing.*;
import java.awt.BorderLayout;
import java.awt.event.*;
import java.util.*;

public class ConsoleOnlyFrame extends ConsoleFrame{
    private Console m_oConsole;

    public ConsoleOnlyFrame(SwingInterface _oI){
	super(_oI);
	m_oConsole = new Console(_oI,_oI.oKernel(),null);
 
	setTitle("Sche::SWING Console Only");
	setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
	setSize(300,200);
	setLocationRelativeTo(null);
	getContentPane().add(m_oConsole.panel(),BorderLayout.CENTER);
	setJMenuBar(new MenuBar());
	setVisible(true);

	addWindowListener(new WindowEventChecker());
    }
    public int makeDecision(String _sMessage){
	return 0;
    }
    class WindowEventChecker implements WindowListener{
	public void windowOpened(WindowEvent e){
	}
	public void windowClosing(WindowEvent e){
	    m_oI.callCommandWith("exit;");
	}
	public void windowClosed(WindowEvent e){
	}
	public void windowIconified(WindowEvent e){
	}
	public void windowDeiconified(WindowEvent e){
	}
	public void windowActivated(WindowEvent e){
	}
	public void windowDeactivated(WindowEvent e){
	}
    }
    class MenuBar extends JMenuBar{
	public MenuBar(){
	    JMenu _oRoot = new JMenu("File");
	    add(_oRoot);
	    JMenuItem _oLoad = new JMenuItem("Load");
	    JMenuItem _oExit = new JMenuItem("Exit");
	    _oRoot.add(_oLoad);
	    _oRoot.add(_oExit);
	    _oLoad.addActionListener(new ActionLoad(m_oI));
	    _oExit.addActionListener(new ActionExit(m_oI));
	}
    }
}
