package xor.main.swing;

import java.util.logging.*;
import javax.swing.*;
import javax.swing.table.*;
import javax.swing.event.*;
import java.awt.*;
import java.text.SimpleDateFormat;
import java.util.*;
import xor.main.*;

public class Log extends Inside{
    private ListLog m_oTable;
    private JScrollPane m_oSP;
    private JSplitPane m_oMain;
    private DetailLog m_oDL;
    static private SimpleDateFormat s_oSDF;
    static private Object[] s_oHeader = {"Time","Level","Message"};

    static{
	s_oSDF = new SimpleDateFormat("mm:ss.S");
    }
    Log(SwingInterface _oI,Kernel _oKernel,MDI _oMDI){
	super(_oKernel,_oI,_oMDI);
	m_oTable = new ListLog();
	m_oMain = new JSplitPane();
	m_oMain.setOrientation(JSplitPane.VERTICAL_SPLIT);
	m_oMain.setDividerLocation((double)0.9);
	m_oSP = new JScrollPane();
	m_oI.oKernel().getELogger().addELoggerListener(new LogChecker());
	m_oMain.setTopComponent(m_oSP);
	m_oDL = new DetailLog();
	m_oMain.setBottomComponent(m_oDL);
    }
    public void set(){
	m_oSP.setVisible(true);
	m_oSP.getViewport().setView(m_oTable);
    }
    public void addLine(Level _oLevel,String _sMessage){
	Date _oDate = new Date();
	Object[] _oRow = {s_oSDF.format(_oDate),_oLevel.getLocalizedName(),_sMessage};
	m_oTable.addRow(_oRow);
    }
    public JComponent panel(){
	return m_oMain;
    }
    public void refreshForce(){}
    public String type(){
	return "Log";
    }
    class ListLog extends JTable{
	private TableModel m_oTableModel;
	
	ListLog(){
	    m_oTableModel = new TableModel();
	    setModel(m_oTableModel);
	    setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
	}
	public void addRow(Object[] _oRow){
	    m_oTableModel.addRow(_oRow);
	}
	public void valueChanged(ListSelectionEvent _oLSE){
	    super.valueChanged(_oLSE);
	    if(_oLSE.getValueIsAdjusting()){
		return;
	    }
	    int _nSRow = getSelectedRow();
	    m_oDL.setLog((String)getValueAt(_nSRow,2));
	}
    }
    class DetailLog extends JPanel{
	private JTextArea m_oTA;
	
	DetailLog(){
	    super(new BorderLayout());
	    m_oTA = new JTextArea();
	    m_oTA.setLineWrap(true);
	    JScrollPane _oSP = new JScrollPane(m_oTA);
	    add(_oSP,BorderLayout.CENTER);
	}
	public void setLog(String _sDetail){
	    m_oTA.setText(_sDetail);
	}
    }
    class LogChecker extends ELoggerAdapter{
	public void add(ELoggerEvent _oEv){
	    addLine(_oEv.getLevel(),_oEv.getMessage());
	}
    }
    class TableModel extends DefaultTableModel{
	TableModel(){
	    super(s_oHeader,0);
	}
	public boolean isCellEditable(int row,int column){
	    return false;
	}
    }
}
