package xor.main.swing;

import javax.swing.*;
import java.awt.BorderLayout;
import java.awt.event.*;
import java.util.*;

public class MDI{
    private SwingInterface m_oI;
    private Map<String,Inside> m_oInsides;
    private RootPaneFactory m_oRPF;
    private RootPane m_oPanel;
    private JPanel m_oRootForAllPanel;
    private InsideFactory m_oIF;

    MDI(SwingInterface _oI){
	m_oRootForAllPanel = new JPanel(new BorderLayout());
	m_oI = _oI;
	m_oRPF = new RootPaneFactory(_oI);
	m_oInsides = new HashMap<String,Inside>();
	setRootPaneTo("tab");
	m_oIF = new InsideFactory(_oI,_oI.oKernel(),this);
	makeWindow("Calendar");
	makeWindow("Picker");
	makeWindow("ScheList");
	makeWindow("Detail");
	makeWindow("Updated");
	startAll();
	m_oRootForAllPanel.add(m_oPanel.panel(),BorderLayout.CENTER);
	m_oI.addWindowShowListener(new WindowShowChecker());
    }
    public RootPane getRootPane(){
	return m_oPanel;
    }
    public void makeWindow(String _sName){
	if(!m_oPanel.exists(_sName)){
	    Inside _oNew = m_oIF.get(_sName);
	    if(_oNew == null){
		return;
	    }
	    m_oPanel.addInside(_oNew,_sName);
	    m_oInsides.put(_sName,_oNew);
	}else{
	    Inside _oNew = m_oInsides.get(_sName);
	    m_oPanel.bringToTop(_sName);
	}
    }
    private void startAll(){
	Iterator _oIt = m_oInsides.keySet().iterator();
	while(_oIt.hasNext()){
	    String _sName = (String)_oIt.next();
	    Inside _oIn = m_oInsides.get(_sName);
	    _oIn.run();
	}
    }
    synchronized public void isDisplayed(){
	Iterator _oIt = m_oInsides.keySet().iterator();
	while(_oIt.hasNext()){
	    String _sName = (String)_oIt.next();
	    Inside _oIn = m_oInsides.get(_sName);
	    _oIn.isDisplayed();
	}
    }
    public JComponent panel(){
	return m_oRootForAllPanel;
    }
    public void setRootPaneTo(String _sType){
	m_oPanel = m_oRPF.get(_sType);
	m_oPanel.addInsides(m_oInsides);
    }
    class WindowShowChecker extends WindowShowAdapter{
	public void show(WindowShowEvent _oE){
	    makeWindow(_oE.getType());
	}
    }
    public int makeDecision(String _sMessage){
	return m_oPanel.makeDecision(_sMessage);
    }
}
