package xor.sche;

import java.util.*;

public class Time extends ScheObj{
    private Date m_oBegin,m_oEnd;

    public void setBegin(Date _oB){m_oBegin = _oB;}
    public void setEnd(Date _oE){m_oEnd = _oE;}

    public Date begin(){  return m_oBegin; }
    public Date end(){  return m_oEnd; }

    public String type(){
	return "sche-time";
    }
    public Date today(){
	return new Date();
    }
    public String status(){
	if(m_oBegin == null && m_oEnd == null){
	    return "halt";
	}
	Date _oToday = today();
	if(m_oBegin != null && m_oBegin.getTime() > _oToday.getTime()){
	    return "coming";
	}else if(m_oEnd != null && m_oEnd.getTime() < _oToday.getTime()){
	    return "done";
	}
	return "progress";
    }
    public boolean overlaps(Time _oT){
	if(
	   (m_oBegin == null &&
	    (_oT.begin() == null || (m_oEnd != null && _oT.begin().getTime() < m_oEnd.getTime())))
	   ||
	   (m_oEnd == null &&
	    (_oT.end() == null || (m_oBegin != null && _oT.end().getTime() > m_oBegin.getTime())))
	   ||
	   (m_oBegin != null &&_oT.begin() == null && _oT.end() != null &&  _oT.end().getTime() > m_oBegin.getTime())
	   ||
	   (m_oEnd != null && _oT.end() == null &&  _oT.begin() != null && _oT.begin().getTime() < m_oEnd.getTime())
	   ||
	   (m_oBegin != null && _oT.end() != null && (m_oEnd == null || _oT.begin() == null) &&
	    m_oBegin.getTime() < _oT.end().getTime())
	   ||
	   (m_oEnd != null && _oT.begin() != null && (m_oBegin == null || _oT.end() == null) &&
	    m_oEnd.getTime() > _oT.begin().getTime())
	   ||
	   (m_oBegin != null && m_oEnd != null && _oT.begin() != null &&_oT.end() != null &&
	    (
	     (m_oBegin.getTime() >= _oT.begin().getTime() && m_oEnd.getTime() <= _oT.end().getTime())
	     ||
	     (m_oBegin.getTime() <= _oT.begin().getTime() && m_oEnd.getTime() >= _oT.end().getTime())
	     )
	    )
	   ){return true;}
	return false;
    }
    public boolean isValid(){
	return true;
    }
    public Date mostImportantTime(){
	if(status().equals("coming")){
	    return m_oBegin;
	}else if(status().equals("progress")){
	    return m_oEnd;
	}
	return null;
    }
    public String toString(){
	if(m_oBegin != null && m_oEnd != null){
	    return m_oBegin+"-"+m_oEnd;
	}else if(m_oBegin == null){
	    return "-"+m_oEnd;
	}else if(m_oEnd == null){
	    return m_oBegin+"-";
	}else{
	    return "-";
	}
    }
}
