/***************************************************************************
 *   Copyright (C) 2004 by TAM(Teppei Tamra)                               *
 *   tam-t@par.odn.ne.jp                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "preeditor.h"

PreEditor::PreEditor(ConfigPointer cfg)
{
    iconvert.set_encoding ("EUC-JP");
    config = cfg;
    if (!convChars.size())
        iconvert.convert(convChars,String("󥡥!~"));
}


PreEditor::~PreEditor()
{
}

WideString PreEditor::text = WideString();
WideString PreEditor::convChars = WideString();
int PreEditor::pos = 0;
IConvert PreEditor::iconvert;

/*!
    \fn PreEditor::getPos()
 */
int PreEditor::getPos()
{
    return(pos);
}


/*!
    \fn PreEditor::getTextLength()
 */
int PreEditor::getTextLength()
{
    return(text.length());
}


/*!
    \fn PreEditor::textIsEmpty()
 */
bool PreEditor::textIsEmpty()
{
    return(text.empty());
}


/*!
    \fn PreEditor::setPos(int p)
 */
void PreEditor::setPos(int p)
{
    if (p < 0) p = 0;
    else if (p > getTextLength()) p = getTextLength();
    pos = p;
}


/*!
    \fn PreEditor::clear()
 */
void PreEditor::clear()
{
    text.clear();
}



/*!
    \fn PreEditor::reset()
 */
void PreEditor::reset()
{
    clear();
    pos = 0;
}


/*!
    \fn PreEditor::getText(bool hosei)
 */
WideString PreEditor::getText(bool hosei)
{
    return(text);
}


/*!
    \fn PreEditor::backspace()
 */
void PreEditor::backspace()
{
    if (getPos() == 0) return;
    text = text.substr(0,pos - 1) + text.substr(pos);
    setPos(pos - 1);
}



/*!
    \fn PreEditor::del()
 */
void PreEditor::del()
{
    if (getPos() == getTextLength()) return;
    text = text.substr(0,pos) + text.substr(pos + 1);
}


/*!
    \fn PreEditor::convHiraKata(WideString &t)
 */
void PreEditor::convHiraKata(WideString &t)
{
    for(unsigned int i = 0;i < t.size();i ++) {
        if ((t[i] >= convChars[HIRA_START]) && (t[i] <= convChars[HIRA_END]))
            t[i] = t[i] - convChars[HIRA_START] + convChars[KATA_START];
    }
    return;
}


/*!
    \fn PreEditor::convKataHira(WideString &t)
 */
void PreEditor::convKataHira(WideString &t)
{
    for(unsigned int i = 0;i < t.size();i ++) {
        if ((t[i] >= convChars[KATA_START]) && (t[i] <= convChars[KATA_END]))
            t[i] = t[i] - convChars[KATA_START] + convChars[HIRA_START];
    }
    return;

}


/*!
    \fn PreEditor::convHanZen(WideString &t)
 */
void PreEditor::convHanZen(WideString &t)
{
    for(unsigned int i = 0;i < t.size();i ++) {
        if ((t[i] >= convChars[ASCII_START]) && (t[i] <= convChars[ASCII_END]))
            t[i] = t[i] - convChars[ASCII_START] + convChars[WASCII_START];
    }
    return;

}


/*!
    \fn PreEditor::convZenHan(WideString &t)
 */
void PreEditor::convZenHan(WideString &t)
{
    for(unsigned int i = 0;i < t.size();i ++) {
        if ((t[i] >= convChars[WASCII_START]) && (t[i] <= convChars[WASCII_START]))
            t[i] = t[i] - convChars[WASCII_START] + convChars[ASCII_START];
    }
    return;

}


/*!
    \fn PreEditor::hiraKata()
 */
void PreEditor::hiraKata()
{
    convHiraKata(text);
}


/*!
    \fn PreEditor::kataHira()
 */
void PreEditor::kataHira()
{
    convKataHira(text);
}


/*!
    \fn PreEditor::keyEventHook(const KeyEvent &key)
 */
bool PreEditor::keyEventHook(const KeyEvent &key)
{
    return(false);
}



/*!
    \fn PreEditor::getModeName()
 */
String PreEditor::getModeName()
{
    String s;
    return(s);
}


/*!
    \fn PreEditor::cancelEvent()
 */
bool PreEditor::cancelEvent()
{
    return(false);
}



/*!
    \fn PreEditor::inputEvent(const KeyEvent &key)
 */
bool PreEditor::inputEvent(const KeyEvent &key)
{
    if (isprint(key.code)){
        String s;
        s = key.get_ascii_code();
        text = text.substr(0,pos) + utf8_mbstowcs(s) + text.substr(pos);
        pos ++;
        return(true);
    }
    return(false);
}


/*!
    \fn PreEditor::getName()
 */
String PreEditor::getName()
{
    return(String("PreEditor"));
}


/*!
    \fn PreEditor::setText(const WideString &t)
 */
void PreEditor::setText(const WideString &t)
{
    text = t;
}

