#
# Copyright (C) 2006 Takashi Nakamoto <bluedwarf@bpost.plala.or.jp>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#

module ScimRubyObject
  # return string to be commited by scim-ruby
  def to_scimruby
    to_s
  end
end

class Object
  include ScimRubyObject
end

class Array
  def to_scimruby
    join(",").toutf8
  end
end

class Hash
  def to_scimruby
    ret = ""
    each{ |key, val| ret += "#{key}: #{val}\n".toutf8 }
    ret
  end
end

class String
  def to_scimruby
    toutf8
  end
end

class File
  def to_scimruby
    ""
  end
end

class ScimRuby
  def ScimRuby.exception_handler(e)
    begin
      raise e
    rescue Exception
      e.message
    end
  end

  def ScimRuby.credit
    authors = ["Takashi Nakamoto <bluedwarf@bpost.plala.or.jp>"]
    contributors = [""]

    ret = "Authors: \n"
    ret += authors.join("\n")
    ret += "\nContributor: \n"
    ret += contributors.join("\n")
  end

  def ScimRuby.clipboard
    require 'gtk2'
    if self.class.constants.include?("Gtk")
      Gtk::init
      Gtk::Clipboard.get(Gdk::Selection::CLIPBOARD).wait_for_text
    else
      ""
    end
  end

  def ScimRuby.valid_syntax?(src)
    begin
      # ToDo: validate Ruby's source
      return true
    rescue
      return false
    end
  end
end

