/*
 *  Copyright (C) 2006 Takashi Nakamoto <bluedwarf@bpost.plala.or.jp
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __SCIM_RUBY_REFERENCE_H__
#define __SCIM_RUBY_REFERENCE_H__

#include <scim.h>
#include <map>
#include <list>
#include "scim_ruby_interpreter.h"

using namespace std;
using namespace scim;

class RubyReference
{
private:
    RubyInterpreter *m_interpreter;
    String m_ri_command;
public:
    RubyReference(RubyInterpreter *interpreter, const String &ri_command);
    ~RubyReference();
    WideString getCandidates(CommonLookupTable &table, const WideString &preeditString, const int caretPos); // return aux string
//    WideString getMethodCandidates(CommonLookupTable &table, const WideString &preeditString, const int caretPos); // return aux string
};

#endif /* __SCIM_RUBY_REFERENCE_H__ */
