/*
 *  Copyright (C) 2006 Takashi Nakamoto <bluedwarf@bpost.plala.or.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * Based on scim-imengine-skeleton.
 * Copyright (C) 2004 Hiroyuki Ikezoe
 * Copyright (C) 2004 - 2005 Takuro Ashie
 */

/*
 * The original code is scim_uim_imengine.cpp in scim-uim-0.1.3. 
 * Copyright (C) 2004 James Su <suzhe@tsinghua.org.cn>
 */

#ifndef __SCIM_RUBY_IMENGINE_H__
#define __SCIM_RUBY_IMENGINE_H__

#include <scim.h>

using namespace scim;

typedef enum{
    COMPLETION,
    HISTORY,
    HIDDEN
} CandidateType;

class RubyInstance : public IMEngineInstanceBase
{
    friend class RubyFactory;

private:
    RubyFactory        *m_factory;

    KeyEvent                m_prev_key;

    /* for candidates window */
    CommonLookupTable       m_lookup_table;
    CandidateType m_candidate_type;

    /* for toolbar */
    PropertyList            m_properties;

    WideString m_preedit_string;
    WideString m_aux_string_base;
    unsigned int m_caret_pos;
    string m_input_mode;

public:
    RubyInstance (RubyFactory *factory,
                  const String    &encoding,
                  int              id = -1);
    virtual ~RubyInstance ();

    virtual bool process_key_event             (const KeyEvent& key);
    virtual void move_preedit_caret            (unsigned int pos);
    virtual void reset                         (void);
    virtual void focus_in                      (void);
    virtual void focus_out                     (void);
    virtual void trigger_property              (const String &property);

private:
    /* processing key event */
    bool   process_key_event_lookup_keybind    (const KeyEvent &key);
    bool   process_key_event_without_preedit   (const KeyEvent &key);
    bool   process_key_event_with_preedit      (const KeyEvent &key);
    bool   process_key_event_with_candidate    (const KeyEvent &key);
    bool   process_remaining_key_event         (const KeyEvent &key);

    void update_completion_candidate(); // return aux string
    void update_history_candidate(); // return aux string
    void update_candidate();
    void hide_candidate();
    void install_properties();
    void switch_input_mode();
};
#endif /* __SCIM_RUBY_IMENGINE_H__ */

