/*
 *  Copyright (C) 2006 Takashi Nakamoto <bluedwarf@bpost.plala.or.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __SCIM_RUBY_KEYBIND_H__
#define __SCIM_RUBY_KEYBIND_H__

#include <scim.h>

using namespace scim;

typedef enum{
    KAKUTEI,
    SHOW_HISTORY,
    PASTE_CLIPBOARD,
    CHANGE_MODE,
    BACKSPACE,
    DELETE,
    GO_FORWARD,
    GO_BACK,
    GOTO_HEAD,
    GOTO_END,
    SELECT_UP,
    SELECT_DOWN,
    NEXT_PAGE,
    PREVIOUS_PAGE,
    CLEAR,
    KEY_CATEGORY_NUM,
} KeyEventCategory;

class KeyBind {
    KeyEventList m_key_events[KEY_CATEGORY_NUM];

public:
    KeyBind  (void);
    ~KeyBind (void);
    
    void set_keys(const String &str, KeyEventCategory category);
    bool match_keys(const KeyEvent &key, KeyEventCategory category);
};

#endif /* __SCIM_RUBY_KEYBIND_H__ */
