/*
 *  Copyright (C) 2006 Takashi Nakamoto <bluedwarf@bpost.plala.or.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __SCIM_RUBY_PREFS_H__
#define __SCIM_RUBY_PREFS_H__

// optoins
#define SCIM_RUBY_CONFIG_IRB_COMMAND "/IMEngine/Ruby/IrbCommand"
#define SCIM_RUBY_CONFIG_IRB_COMMAND_DEFAULT "irb"

#define SCIM_RUBY_CONFIG_RI_COMMAND "/IMEngine/Ruby/RiCommand"
#define SCIM_RUBY_CONFIG_RI_COMMAND_DEFAULT "ri1.8"

#define SCIM_RUBY_CONFIG_REQUIRED_LIBRARIES "/IMEngine/Ruby/RequiredLibraries"
#define SCIM_RUBY_CONFIG_REQUIRED_LIBRARIES_DEFAULT ""

#define SCIM_RUBY_CONFIG_PRE_INCLUDE_MODULES "/IMEngine/Ruby/PreIncludeModules"
#define SCIM_RUBY_CONFIG_PRE_INCLUDE_MODULES_DEFAULT "Math,ScimRuby"

#define SCIM_RUBY_CONFIG_USE_COMPLETION "/IMEngine/Ruby/UseCompletion"
#define SCIM_RUBY_CONFIG_USE_COMPLETION_DEFAULT "0"

#define SCIM_RUBY_CONFIG_HISTORY_SIZE "/IMEngine/Ruby/HistorySize"
#define SCIM_RUBY_CONFIG_HISTORY_SIZE_DEFAULT "10"

// common keys
#define SCIM_RUBY_CONFIG_KAKUTEI_KEY "/IMEngine/Ruby/Kakutei"
#define SCIM_RUBY_CONFIG_KAKUTEI_KEY_DEFAULT "Return,KP_Enter,Control+j,Control+J"

#define SCIM_RUBY_CONFIG_SHOW_HISTORY_KEY "/IMEngine/Ruby/ShowHistory"
#define SCIM_RUBY_CONFIG_SHOW_HISTORY_KEY_DEFAULT "Control+h,Control+H"

#define SCIM_RUBY_CONFIG_PASTE_CLIPBOARD_KEY "/IMEngine/Ruby/PasteClipboard"
#define SCIM_RUBY_CONFIG_PASTE_CLIPBOARD_KEY_DEFAULT "Control+V,Control+v"

// mode keys
#define SCIM_RUBY_CONFIG_CHANGE_MODE_KEY "/IMEngine/Ruby/ChangeMode"
#define SCIM_RUBY_CONFIG_CHANGE_MODE_KEY_DEFAULT "Zenkaku_Hankaku,Shift+space"

// keys related to the caret
#define SCIM_RUBY_CONFIG_BACKSPACE_KEY "/IMEngine/Ruby/Backspace"
#define SCIM_RUBY_CONFIG_BACKSPACE_KEY_DEFAULT "BackSpace"

#define SCIM_RUBY_CONFIG_DELETE_KEY "/IMEngine/Ruby/Delete"
#define SCIM_RUBY_CONFIG_DELETE_KEY_DEFAULT "Delete,Control+d,Control+D"

#define SCIM_RUBY_CONFIG_GO_FORWARD_KEY "/IMEngine/Ruby/GoForward"
#define SCIM_RUBY_CONFIG_GO_FORWARD_KEY_DEFAULT "Right,Control+f,Control+F"

#define SCIM_RUBY_CONFIG_GO_BACK_KEY "/IMEngine/Ruby/GoBack"
#define SCIM_RUBY_CONFIG_GO_BACK_KEY_DEFAULT "Left,Control+b,Control+B"

#define SCIM_RUBY_CONFIG_GOTO_HEAD_KEY "/IMEngine/Ruby/GotoHead"
#define SCIM_RUBY_CONFIG_GOTO_HEAD_KEY_DEFAULT "Control+a,Control+A"

#define SCIM_RUBY_CONFIG_GOTO_END_KEY "/IMEngine/Ruby/GotoEnd"
#define SCIM_RUBY_CONFIG_GOTO_END_KEY_DEFAULT "Control+e,Control+E"

#define SCIM_RUBY_CONFIG_SELECT_UP_KEY "/IMEngine/Ruby/SelectUp"
#define SCIM_RUBY_CONFIG_SELECT_UP_KEY_DEFAULT "Up"

#define SCIM_RUBY_CONFIG_SELECT_DOWN_KEY "/IMEngine/Ruby/SelectDown"
#define SCIM_RUBY_CONFIG_SELECT_DOWN_KEY_DEFAULT "Down"

#define SCIM_RUBY_CONFIG_NEXT_PAGE_KEY "/IMEngine/Ruby/NextPage"
#define SCIM_RUBY_CONFIG_NEXT_PAGE_KEY_DEFAULT "Page_Down"

#define SCIM_RUBY_CONFIG_PREVIOUS_PAGE_KEY "/IMEngine/Ruby/PreviousPage"
#define SCIM_RUBY_CONFIG_PREVIOUS_PAGE_KEY_DEFAULT "Page_Up"

#define SCIM_RUBY_CONFIG_CLEAR_KEY "/IMEngine/Ruby/Clear"
#define SCIM_RUBY_CONFIG_CLEAR_KEY_DEFAULT "Control+c,Control+C"

#endif /* __SCIM_RUBY_PREFS_H__ */
/*
vi:ts=4:nowrap:ai:expandtab
*/
