/*
 *  Copyright (C) 2006 Takashi Nakamoto <bluedwarf@bpost.plala.or.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#define Uses_SCIM_UTILITY
#define Uses_SCIM_LOOKUP_TABLE
#define Uses_SCIM_ATTRIBUTE


#ifdef HAVE_CONFIG_H
  #include <config.h>
#endif

#include <scim.h>
#include <stdio.h>
#include <map>
#include <list>
#include <vector>
#include "scim_ruby_reference.h"
#include "scim_ruby_interpreter.h"

using namespace std;
using namespace scim;

RubyReference::RubyReference(RubyInterpreter *interpreter, const String &ri_command)
    : m_interpreter (interpreter),
      m_ri_command (ri_command)
{
}

RubyReference::~RubyReference()
{
}

WideString RubyReference::getCandidates(CommonLookupTable &table, const WideString &preeditString, const int caretPos)
{
    table.clear();
    WideString subject = preeditString.substr(0, caretPos);
   
    // get all candidates which this object has
    list<WideString> candidates;
    m_interpreter->get_candidates(subject, candidates);

    list<WideString>::iterator p = candidates.begin();
    while(p != candidates.end())
    {
	// ToDo: get detailed method information like arguments with ri

	// attribute
	AttributeList attr_list;
	if( p == candidates.begin() )
	{
	    Attribute attr = Attribute(0,
				       p->length(),
				       SCIM_ATTR_FOREGROUND,
				       SCIM_RGB_COLOR(255,0,0));
	    attr_list.push_back(attr);
	}
	// ToDo: set attribute for superfical style
	table.append_candidate(*p, attr_list);
	p++;
    }

    // return object name for aux string
    return utf8_mbstowcs("Candidates");
}
/*
WideString RubyReference::getMethodCandidates(CommonLookupTable &table, const WideString &preeditString, const int caretPos)
{
    table.clear();

    WideString object_method = preeditString.substr(0, caretPos);

    int dot_pos = object_method.rfind(SCIM_KEY_period, caretPos);

    if(dot_pos == WideString::npos)
	return WideString();

    WideString method = object_method.substr(dot_pos+1, caretPos-dot_pos-1);
    WideString object = object_method.substr(0, dot_pos);

    // get all methods which this object has
    list<WideString> methods;
    m_interpreter->get_methods(object, methods);

    // append methods whose head is the same as "method" to candidates
    list<WideString>::iterator p = methods.begin();
    while(p != methods.end())
    {
	if(method == p->substr(0, method.length()))
	{
	    table.append_candidate(*p);
	    // ToDo: set attribute for superfical style
	}
	p++;
    }

    // ri command is not necessary now
    // ToDo:g et detailed method information like arguments with ri

    // return object name for aux string
    return utf8_mbstowcs("Methods of ") + object;
}
*/
