/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.sablecc;

import java.util.Set;
import java.util.TreeSet;
import org.sablecc.sablecc.CharSet;
import org.sablecc.sablecc.NFA;
import org.sablecc.sablecc.ResolveIds;
import org.sablecc.sablecc.analysis.DepthFirstAdapter;
import org.sablecc.sablecc.node.ACharBasic;
import org.sablecc.sablecc.node.ACharChar;
import org.sablecc.sablecc.node.AConcat;
import org.sablecc.sablecc.node.ADecChar;
import org.sablecc.sablecc.node.AGrammar;
import org.sablecc.sablecc.node.AHelperDef;
import org.sablecc.sablecc.node.AHexChar;
import org.sablecc.sablecc.node.AIdBasic;
import org.sablecc.sablecc.node.AIntervalSet;
import org.sablecc.sablecc.node.AMinusBinOp;
import org.sablecc.sablecc.node.AOperationSet;
import org.sablecc.sablecc.node.APlusBinOp;
import org.sablecc.sablecc.node.APlusUnOp;
import org.sablecc.sablecc.node.AQMarkUnOp;
import org.sablecc.sablecc.node.ARegExp;
import org.sablecc.sablecc.node.ARegExpBasic;
import org.sablecc.sablecc.node.ARegExpTail;
import org.sablecc.sablecc.node.ASetBasic;
import org.sablecc.sablecc.node.AStarUnOp;
import org.sablecc.sablecc.node.AStateList;
import org.sablecc.sablecc.node.AStateListTail;
import org.sablecc.sablecc.node.AStringBasic;
import org.sablecc.sablecc.node.ATokenDef;
import org.sablecc.sablecc.node.ATokens;
import org.sablecc.sablecc.node.AUnExp;
import org.sablecc.sablecc.node.Node;
import org.sablecc.sablecc.node.Start;

public class ConstructNFA
extends DepthFirstAdapter {
    private ResolveIds ids;
    private String stateName;
    private int i;

    public void outStart(Start start) {
        this.setOut(start, this.getOut(start.getPGrammar()));
        if (this.getOut(start.getPGrammar()) != null) {
            this.setOut(start.getPGrammar(), null);
        }
    }

    public void outAGrammar(AGrammar aGrammar) {
        this.setOut(aGrammar, this.getOut(aGrammar.getTokens()));
        if (this.getOut(aGrammar.getTokens()) != null) {
            this.setOut(aGrammar.getTokens(), null);
        }
    }

    public void outAHelperDef(AHelperDef aHelperDef) {
        this.setOut(aHelperDef, this.getOut(aHelperDef.getRegExp()));
        if (this.getOut(aHelperDef.getRegExp()) != null) {
            this.setOut(aHelperDef.getRegExp(), null);
        }
    }

    public void outATokens(ATokens aTokens) {
        ATokenDef[] aTokenDefArray = aTokens.getTokenDefs().toArray(new ATokenDef[0]);
        NFA nFA = null;
        int n = aTokenDefArray.length - 1;
        while (n >= 0) {
            NFA nFA2 = (NFA)this.getOut(aTokenDefArray[n]);
            if (nFA2 != null) {
                nFA = nFA == null ? nFA2 : nFA2.merge(nFA);
                if (this.getOut(aTokenDefArray[n]) != null) {
                    this.setOut(aTokenDefArray[n], null);
                }
            }
            --n;
        }
        if (nFA != null) {
            this.setOut(aTokens, nFA);
        }
    }

    public void outATokenDef(ATokenDef aTokenDef) {
        Set set = (Set)this.getOut(aTokenDef.getStateList());
        Object object = this.getOut(aTokenDef.getRegExp());
        if (set == null || set.size() == 0 || set.contains(this.stateName)) {
            String string;
            NFA nFA = object instanceof NFA ? (NFA)object : new NFA((CharSet)object);
            nFA.states[nFA.states.length - 1].accept = string = (String)this.ids.names.get(aTokenDef);
            this.setOut(aTokenDef, nFA);
        }
        if (this.getOut(aTokenDef.getStateList()) != null) {
            this.setOut(aTokenDef.getStateList(), null);
        }
        if (this.getOut(aTokenDef.getRegExp()) != null) {
            this.setOut(aTokenDef.getRegExp(), null);
        }
    }

    public void outAStateList(AStateList aStateList) {
        TreeSet<String> treeSet = new TreeSet<String>();
        AStateListTail[] aStateListTailArray = aStateList.getStateLists().toArray(new AStateListTail[0]);
        int n = aStateListTailArray.length - 1;
        while (n >= 0) {
            String string = aStateListTailArray[n].getId().getText().toUpperCase();
            treeSet.add(string);
            --n;
        }
        treeSet.add(aStateList.getId().getText().toUpperCase());
        this.setOut(aStateList, treeSet);
    }

    public void outARegExp(ARegExp aRegExp) {
        Object object;
        ARegExpTail[] aRegExpTailArray = aRegExp.getConcats().toArray(new ARegExpTail[0]);
        NFA nFA = null;
        int n = aRegExpTailArray.length - 1;
        while (n >= 0) {
            object = this.getOut(aRegExpTailArray[n]);
            NFA nFA2 = object instanceof NFA ? (NFA)object : new NFA((CharSet)object);
            nFA = nFA == null ? nFA2 : nFA2.alternate(nFA);
            if (this.getOut(aRegExpTailArray[n]) != null) {
                this.setOut(aRegExpTailArray[n], null);
            }
            --n;
        }
        if (nFA != null) {
            Object object2 = this.getOut(aRegExp.getConcat());
            object = object2 instanceof NFA ? (NFA)object2 : new NFA((CharSet)object2);
            this.setOut(aRegExp, ((NFA)object).alternate(nFA));
        } else {
            this.setOut(aRegExp, this.getOut(aRegExp.getConcat()));
        }
        if (this.getOut(aRegExp.getConcat()) != null) {
            this.setOut(aRegExp.getConcat(), null);
        }
    }

    public void outARegExpTail(ARegExpTail aRegExpTail) {
        this.setOut(aRegExpTail, this.getOut(aRegExpTail.getConcat()));
        if (this.getOut(aRegExpTail.getConcat()) != null) {
            this.setOut(aRegExpTail.getConcat(), null);
        }
    }

    public void outAConcat(AConcat aConcat) {
        AUnExp[] aUnExpArray = aConcat.getUnExps().toArray(new AUnExp[0]);
        if (aUnExpArray.length == 0) {
            this.setOut(aConcat, new NFA());
        } else if (aUnExpArray.length == 1) {
            this.setOut(aConcat, this.getOut(aUnExpArray[0]));
            if (this.getOut(aUnExpArray[0]) != null) {
                this.setOut(aUnExpArray[0], null);
            }
        } else {
            NFA nFA = null;
            int n = aUnExpArray.length - 1;
            while (n >= 0) {
                Object object = this.getOut(aUnExpArray[n]);
                NFA nFA2 = object instanceof NFA ? (NFA)object : new NFA((CharSet)object);
                nFA = nFA == null ? nFA2 : nFA2.concatenate(nFA);
                if (this.getOut(aUnExpArray[n]) != null) {
                    this.setOut(aUnExpArray[n], null);
                }
                --n;
            }
            this.setOut(aConcat, nFA);
        }
    }

    public void outAUnExp(AUnExp aUnExp) {
        Object object = this.getOut(aUnExp.getBasic());
        int n = 32;
        if (aUnExp.getUnOp() != null) {
            n = ((Character)this.getOut(aUnExp.getUnOp())).charValue();
        }
        switch (n) {
            case 42: {
                NFA nFA = object instanceof NFA ? (NFA)object : new NFA((CharSet)object);
                this.setOut(aUnExp, nFA.zeroOrMore());
                break;
            }
            case 63: {
                NFA nFA = object instanceof NFA ? (NFA)object : new NFA((CharSet)object);
                this.setOut(aUnExp, nFA.zeroOrOne());
                break;
            }
            case 43: {
                NFA nFA = object instanceof NFA ? (NFA)object : new NFA((CharSet)object);
                this.setOut(aUnExp, nFA.oneOrMore());
                break;
            }
            default: {
                this.setOut(aUnExp, object);
            }
        }
        if (this.getOut(aUnExp.getBasic()) != null) {
            this.setOut(aUnExp.getBasic(), null);
        }
        if (this.getOut(aUnExp.getUnOp()) != null) {
            this.setOut(aUnExp.getUnOp(), null);
        }
    }

    public void outACharBasic(ACharBasic aCharBasic) {
        char c = ((Character)this.getOut(aCharBasic.getChar())).charValue();
        this.setOut(aCharBasic, new CharSet(c));
        if (this.getOut(aCharBasic.getChar()) != null) {
            this.setOut(aCharBasic.getChar(), null);
        }
    }

    public void outASetBasic(ASetBasic aSetBasic) {
        this.setOut(aSetBasic, this.getOut(aSetBasic.getSet()));
        if (this.getOut(aSetBasic.getSet()) != null) {
            this.setOut(aSetBasic.getSet(), null);
        }
    }

    public void outAStringBasic(AStringBasic aStringBasic) {
        String string = aStringBasic.getString().getText();
        string = string.substring(1, string.length() - 1);
        this.setOut(aStringBasic, new NFA(string));
    }

    public void outAIdBasic(AIdBasic aIdBasic) {
        Object object = this.getOut((Node)this.ids.helpers.get(aIdBasic.getId().getText()));
        if (object instanceof NFA) {
            this.setOut(aIdBasic, ((NFA)object).clone());
        } else {
            this.setOut(aIdBasic, ((CharSet)object).clone());
        }
    }

    public void outARegExpBasic(ARegExpBasic aRegExpBasic) {
        this.setOut(aRegExpBasic, this.getOut(aRegExpBasic.getRegExp()));
        if (this.getOut(aRegExpBasic.getRegExp()) != null) {
            this.setOut(aRegExpBasic.getRegExp(), null);
        }
    }

    public void outACharChar(ACharChar aCharChar) {
        this.setOut(aCharChar, new Character(aCharChar.getChar().getText().charAt(1)));
    }

    public void outADecChar(ADecChar aDecChar) {
        this.setOut(aDecChar, new Character((char)Integer.parseInt(aDecChar.getDecChar().getText())));
    }

    public void outAHexChar(AHexChar aHexChar) {
        this.setOut(aHexChar, new Character((char)Integer.parseInt(aHexChar.getHexChar().getText().substring(2), 16)));
    }

    public void outAOperationSet(AOperationSet aOperationSet) {
        try {
            CharSet charSet = (CharSet)this.getOut(aOperationSet.getLeft());
            CharSet charSet2 = (CharSet)this.getOut(aOperationSet.getRight());
            char c = ((Character)this.getOut(aOperationSet.getBinOp())).charValue();
            switch (c) {
                case '+': {
                    this.setOut(aOperationSet, charSet.union(charSet2));
                    break;
                }
                case '-': {
                    this.setOut(aOperationSet, charSet.diff(charSet2));
                }
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(aOperationSet + " is invalid.");
        }
        if (this.getOut(aOperationSet.getLeft()) != null) {
            this.setOut(aOperationSet.getLeft(), null);
        }
        if (this.getOut(aOperationSet.getBinOp()) != null) {
            this.setOut(aOperationSet.getBinOp(), null);
        }
        if (this.getOut(aOperationSet.getRight()) != null) {
            this.setOut(aOperationSet.getRight(), null);
        }
    }

    public void outAIntervalSet(AIntervalSet aIntervalSet) {
        char c;
        char c2 = ((Character)this.getOut(aIntervalSet.getLeft())).charValue();
        if (c2 > (c = ((Character)this.getOut(aIntervalSet.getRight())).charValue())) {
            throw new RuntimeException(aIntervalSet + " is invalid.");
        }
        this.setOut(aIntervalSet, new CharSet(c2, c));
        if (this.getOut(aIntervalSet.getLeft()) != null) {
            this.setOut(aIntervalSet.getLeft(), null);
        }
        if (this.getOut(aIntervalSet.getRight()) != null) {
            this.setOut(aIntervalSet.getRight(), null);
        }
    }

    public void outAStarUnOp(AStarUnOp aStarUnOp) {
        this.setOut(aStarUnOp, new Character('*'));
    }

    public void outAQMarkUnOp(AQMarkUnOp aQMarkUnOp) {
        this.setOut(aQMarkUnOp, new Character('?'));
    }

    public void outAPlusUnOp(APlusUnOp aPlusUnOp) {
        this.setOut(aPlusUnOp, new Character('+'));
    }

    public void outAPlusBinOp(APlusBinOp aPlusBinOp) {
        this.setOut(aPlusBinOp, new Character('+'));
    }

    public void outAMinusBinOp(AMinusBinOp aMinusBinOp) {
        this.setOut(aMinusBinOp, new Character('-'));
    }

    public Object getOut(Node node) {
        if (node == null) {
            return null;
        }
        return super.getOut(node);
    }

    public void setOut(Node node, Object object) {
        if (node == null) {
            throw new NullPointerException();
        }
        super.setOut(node, object);
    }

    ConstructNFA(ResolveIds resolveIds, String string) {
        this.ids = resolveIds;
        this.stateName = string;
    }
}

