/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.sablecc;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.LinkedList;
import org.sablecc.sablecc.MacroExpander;
import org.sablecc.sablecc.ResolveIds;
import org.sablecc.sablecc.analysis.DepthFirstAdapter;
import org.sablecc.sablecc.node.ACharBasic;
import org.sablecc.sablecc.node.ACharChar;
import org.sablecc.sablecc.node.AConcat;
import org.sablecc.sablecc.node.ARegExp;
import org.sablecc.sablecc.node.AStringBasic;
import org.sablecc.sablecc.node.ATokenDef;
import org.sablecc.sablecc.node.AUnExp;
import org.sablecc.sablecc.node.PBasic;
import org.sablecc.sablecc.node.PChar;

public class GenTokens
extends DepthFirstAdapter {
    private MacroExpander macros;
    private ResolveIds ids;
    private File pkgDir;
    private String pkgName;
    String text;

    public void inATokenDef(ATokenDef aTokenDef) {
        LinkedList linkedList;
        BufferedWriter bufferedWriter;
        String string = (String)this.ids.names.get(aTokenDef);
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(new File(this.pkgDir, string + ".java")));
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, string + ".java").getAbsolutePath());
        }
        this.text = null;
        ARegExp aRegExp = (ARegExp)aTokenDef.getRegExp();
        AConcat aConcat = (AConcat)aRegExp.getConcat();
        LinkedList linkedList2 = aRegExp.getConcats();
        if (linkedList2.size() == 0 && (linkedList = aConcat.getUnExps()).size() == 1) {
            PChar pChar;
            AUnExp aUnExp = (AUnExp)linkedList.getFirst();
            PBasic pBasic = aUnExp.getBasic();
            if (pBasic instanceof AStringBasic && aUnExp.getUnOp() == null) {
                this.text = ((AStringBasic)pBasic).getString().getText();
                this.text = this.text.substring(1, this.text.length() - 1);
            } else if (pBasic instanceof ACharBasic && aUnExp.getUnOp() == null && (pChar = ((ACharBasic)pBasic).getChar()) instanceof ACharChar) {
                this.text = ((ACharChar)pChar).getChar().getText();
                this.text = this.text.substring(1, this.text.length() - 1);
            }
        }
        try {
            if (this.text == null) {
                this.ids.fixedTokens.put(aTokenDef, new Boolean(false));
                this.macros.apply(bufferedWriter, "VariableTextToken", new String[]{this.pkgName, this.ids.pkgName.equals("") ? "analysis" : this.ids.pkgName + ".analysis", string});
            } else {
                this.ids.fixedTokens.put(aTokenDef, new Boolean(true));
                this.macros.apply(bufferedWriter, "FixedTextToken", new String[]{this.pkgName, this.ids.pkgName.equals("") ? "analysis" : this.ids.pkgName + ".analysis", string, this.processText(this.text)});
                this.ids.errorNames.put(aTokenDef, "'" + this.text + '\'');
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, string + ".java").getAbsolutePath());
        }
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private final String processText(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '\b': {
                    stringBuffer.append("\\t");
                    break;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    break;
                }
                case '\'': {
                    stringBuffer.append("\\'");
                    break;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public GenTokens(ResolveIds resolveIds) {
        this.ids = resolveIds;
        try {
            this.macros = new MacroExpander(new InputStreamReader(this.getClass().getResourceAsStream("tokens.txt")));
        }
        catch (IOException iOException) {
            throw new RuntimeException("unable to open tokens.txt.");
        }
        this.pkgDir = new File(resolveIds.pkgDir, "node");
        String string = this.pkgName = resolveIds.pkgName.equals("") ? "node" : resolveIds.pkgName + ".node";
        if (!this.pkgDir.exists() && !this.pkgDir.mkdir()) {
            throw new RuntimeException("Unable to create " + this.pkgDir.getAbsolutePath());
        }
    }
}

