package a3test.basic;

import javax.media.j3d.*;
import javax.vecmath.*;
import java.awt.*;
import java.awt.event.*;
import com.sun.j3d.utils.universe.SimpleUniverse;
//import jp.sourceforge.acerola3d.*;
import jp.sourceforge.acerola3d.a3.*;

public class A3 {
    Frame frame;
    Panel panel;

    public A3() {
        frame = new Frame("A3");
        panel = new Panel();

        frame.add(panel);

        GraphicsConfiguration con = SimpleUniverse.getPreferredConfiguration();
        Canvas3D canvas = new Canvas3D(con);
        canvas.setSize(300,300);
        panel.add(canvas);

        SimpleUniverse universe = new SimpleUniverse(canvas);
        universe.addBranchGraph(createSceneGraph());
        universe.getViewingPlatform().setNominalViewingTransform();

        frame.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent we) {
                disposeThis();
            }
        });
        frame.pack();
        frame.setVisible(true);
    }

    BranchGroup createSceneGraph() {
        BoundingSphere bs = new BoundingSphere(new Point3d(),100.0);
        BranchGroup bg = new BranchGroup();

        Transform3D t = new Transform3D();
        t.set(new Vector3f(0.0f,0.0f,0.0f));
        TransformGroup tg = new TransformGroup(t);
        tg.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
        tg.addChild(useA3());
        bg.addChild(tg);

        Transform3D t2 = new Transform3D();
        t2.set(new Vector3f(0.0f,0.0f,10.0f));
        TransformGroup tg2 = new TransformGroup(t2);
        PointLight pl = new PointLight();
        pl.setInfluencingBounds(bs);
        tg2.addChild(pl);
        bg.addChild(tg2);

        return bg;
    }

    Node useA3() {
        TransformGroup tg = new TransformGroup();
        Transform3D t = new Transform3D();
        t.set(1.0,new Vector3d(0.0,0.0,0.0));
        tg.setTransform(t);

        Action3D a3 = null;
        try {
//          a3 = Action3D.load("file:///home/ksaito/media/A3/axis/axis.a3");
            a3 = Action3D.load("x-res:///axis.a3");
        } catch (Exception e) {
            e.printStackTrace();
        }
        //a3.change(1);
        a3.changeImmediately(1);
        tg.addChild(a3.getNode());
        return tg;
    }

    void disposeThis() {
        frame.dispose();
        System.exit(0);
    }

    public static void main(String args[]) {
        new A3();
    }
}
