/*
 * Acerola3DのIntroductionのページで紹介するためのデモ．
 * なるべく短かくてAcerola3Dの多くの機能が確認できるようにする．
 *
 * 1. マウスナビゲーションが一行で設定可能
 * 1. 背景に動的な物，BGM，スカイボックスなどが含められる．
 * 1. KeyPressedイベントで座標を変更しているけど
 *    補間が効いているのでカクカクしない
 * 1. キャラクタの向きが自動でかわる
 * 1. キャラクタのモーションがスピードに応じて自動的に3段階でかわる
 * 1. キャラクタの足音がキャラクタの距離に応じて減衰
 * 1. キャラクタの足音にキャラクタの向きに対応したパンが設定される
 *
 * このデモで説明しきれない機能は．．．
 *
 * 1. 全画面表示機能，Widget機能，マルチキャンバス機能
 * 1. 着せ替え機能
 * 1. ピッキング
 * 1. 複数のシーン
 * 1. 
 * 1. その他，多数
 *
 */
package a3test.demo;

import jp.sourceforge.acerola3d.a3.*;
import java.awt.event.*;
import javax.vecmath.Vector3d;

public class Demo extends KeyAdapter {
    static Action3D a3;
    static Vector3d loc;
    public static void main(String args[]) throws Exception {
        A3Window w = new A3Window(500,300);
        w.setNavigationMode(A3CanvasInterface.NaviMode.WALK);
        w.addKeyListener(new Demo());
        w.setCameraLocImmediately(0.0,1.0,5.0);
        Action3D back = new Action3D("x-res://background7.a3");
        back.setSoundGain(0.1);
        w.setBackground(back);
        a3 = new Action3D("x-res:///footfalls.a3");
        loc = new Vector3d(0.0,0.3,0.0);
        a3.setLoc(loc);
        a3.setEnableBehavior(true);
        a3.setAutoDirectionControl(true);
        a3.setAutoActionControl(true);
        w.add(a3);
    }
    public void keyPressed(KeyEvent e) {
        double speed = (e.getModifiersEx()&KeyEvent.SHIFT_DOWN_MASK)!=0?0.15:0.05;
        switch (e.getKeyCode()) {
        case KeyEvent.VK_RIGHT:loc.x+=speed;a3.setLoc(loc);break;
        case KeyEvent.VK_LEFT: loc.x-=speed;a3.setLoc(loc);break;
        case KeyEvent.VK_UP:   loc.z-=speed;a3.setLoc(loc);break;
        case KeyEvent.VK_DOWN: loc.z+=speed;a3.setLoc(loc);break;
        }
    }
}
