package a3test.etc;

import jp.sourceforge.acerola3d.a3.*;
import java.net.URL;
import javax.swing.*;
import java.awt.*;

/*
 * Acerola3Dファイルから各種メタ情報が取り出せるかのテスト。
 */
public class MetadataTest {
    public static void main(String args[]) throws Exception {
        Action3D a3 = new Action3D("x-res:///api_test.a3");
        //Action3D a3 = new Action3D("file:///Users/ksaito/media/A3/api_test");
        //Action3D a3 = new Action3D("x-res:///axis.a3");
        URL url = a3.getHTML();
        System.out.println("html:");
        System.out.println("    "+url);

        System.out.println("tag:");
        String tags[] = a3.getTags();
        for (int i=0;i<tags.length;i++) {
            System.out.println("    "+tags[i]);
        }
        System.out.println("profile:");
        String profiles[] = a3.getProfiles();
        for (int i=0;i<profiles.length;i++) {
            System.out.println("    "+profiles[i]);
        }
        System.out.println("thumbnails:");
        URL thumbnails[] = a3.getThumbnails();
        for (int i=0;i<thumbnails.length;i++) {
            System.out.println("    "+thumbnails[i].toString());
        }
        System.out.println("rdf:");
        String rdf = a3.getRDF();
        System.out.println(rdf);
        System.out.println("comment:");
        String comment = a3.getComment();
        System.out.println(comment);
        System.out.flush();

        if (url!=null) {
            JFrame f = new JFrame();
            f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
            JEditorPane pane = new JEditorPane();
            pane.setPreferredSize(new Dimension(300,300));
            pane.setEditable(false);
            pane.setContentType("text/html");
            f.add(pane);
            f.pack();
            f.setVisible(true);
            pane.setPage(url);
        }
    }
}
