package a3test.etc;

import jp.sourceforge.acerola3d.a3.*;
import javax.vecmath.*;

public class RayPickingTest {
    public static void main(String args[]) throws Exception {
        A3Window w = new A3Window(300,300);
        w.setCameraLocImmediately(0,0,10);
        Action3D a3_1 = new Action3D("x-res:///axis.a3");
        Action3D a3_2 = new Action3D("x-res:///axis.a3");
        Action3D a3_3 = new Action3D("x-res:///axis.a3");
        Action3D a3_4 = new Action3D("x-res:///axis.a3");
        a3_1.setLoc( 3.0, 3.0,0.0);
        a3_2.setLoc(-3.0, 3.0,0.0);
        a3_3.setLoc(-3.0,-3.0,0.0);
        a3_4.setLoc( 3.0,-3.0,0.0);
        a3_1.setUserData("a3_1");
        a3_2.setUserData("a3_2");
        a3_3.setUserData("a3_3");
        a3_4.setUserData("a3_4");
        w.add(a3_1);
        w.add(a3_2);
        w.add(a3_3);
        w.add(a3_4);

        Vector3d origin = new Vector3d(0,0,0);
        Vector3d dir = new Vector3d(-1,-1,0);
        A3Object a3 = null;

        for (double d=0.0;d<361.0;d=d+5.0) {
            System.out.printf("deg: %3.1f\n",d);
            double t = 2.0*Math.PI*d/360.0;
            dir.x = Math.cos(t);
            dir.y = Math.sin(t);
            a3 = w.pick(origin,dir);
            if (a3==null)
                System.out.println("null");
            else
                System.out.println(a3.getUserData());
            Thread.sleep(100);
        }
    }
}
