package a3test.subcanvas;

import jp.sourceforge.acerola3d.a3.*;

import javax.swing.JFrame;
import java.awt.*;
import java.awt.event.*;

public class A3SubCanvasControllerTest extends KeyAdapter {
    //A3SubCanvas subCanvas;
    JA3SubCanvas subCanvas;
    public A3SubCanvasControllerTest() throws Exception {
        //A3Canvas mainCanvas = A3Canvas.createA3Canvas(300,300);
        JA3Canvas mainCanvas = JA3Canvas.createJA3Canvas(300,300);

        //subCanvas = A3SubCanvas.createA3SubCanvas(300,300);
        subCanvas = JA3SubCanvas.createJA3SubCanvas(300,300);
        //subCanvas.addKeyListener(this);
        mainCanvas.addKeyListener(this); //なぜだ！gaha

        JFrame f = new JFrame("A3SubCanvasControllerTest");
        f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        f.setLayout(new GridLayout(1,2));
        f.add(mainCanvas);
        f.add(subCanvas);
        f.pack();
        f.setVisible(true);

        mainCanvas.setNavigationMode(A3CanvasInterface.NaviMode.EDIT);
        mainCanvas.addA3SubCanvas(subCanvas);
        Action3D a3 = new Action3D("x-res:///axis.a3");
        a3.setLabel("label test");
        mainCanvas.add(a3);

        subCanvas.setCameraLoc(10.0,0.0,10.0);
        subCanvas.setCameraRot(0.0,Math.PI/4.0,0.0);
    }
    public void keyTyped(KeyEvent e) {
        System.out.println("'"+e.getKeyChar()+"' pressed.");
        if (e.getKeyChar()=='n')
            subCanvas.setNavigationMode(A3CanvasInterface.NaviMode.NONE);
        else if (e.getKeyChar()=='w')
            subCanvas.setNavigationMode(A3CanvasInterface.NaviMode.WALK);
        else if (e.getKeyChar()=='e')
            subCanvas.setNavigationMode(A3CanvasInterface.NaviMode.EXAMINE);
        else if (e.getKeyChar()=='f')
            subCanvas.setNavigationMode(A3CanvasInterface.NaviMode.FLY);
        else if (e.getKeyChar()=='d')
            subCanvas.setNavigationMode(A3CanvasInterface.NaviMode.EDIT);
        else if (e.getKeyChar()=='s')
            subCanvas.setNavigationMode(A3CanvasInterface.NaviMode.SIMPLE);
        else if (e.getKeyChar()=='c')
            subCanvas.setNavigationMode(A3CanvasInterface.NaviMode.CHASE);
        else if (e.getKeyChar()=='r')
            subCanvas.resetCamera();

    }
    public static void main(String args[]) throws Exception {
        new A3SubCanvasControllerTest();
    }
}
