/*
 * $RCSfile: ConstMFVec3f.java,v $
 *
 *      @(#)ConstMFVec3f.java 1.11 98/11/05 20:34:14
 *
 * Copyright (c) 1996-1998 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Sun grants you ("Licensee") a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Sun.
 *
 * This software is provided "AS IS," without a warranty of any kind. ALL
 * EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
 * IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE
 * LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
 * OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS
 * LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
 * INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
 * CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
 * OR INABILITY TO USE SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *
 * This software is not designed or intended for use in on-line control of
 * aircraft, air traffic, aircraft navigation or aircraft communications; or in
 * the design, construction, operation or maintenance of any nuclear
 * facility. Licensee represents and warrants that it will not use or
 * redistribute the Software for such purposes.
 *
 * $Revision: 1.2 $
 * $Date: 2005/02/03 23:06:53 $
 * $State: Exp $
 */
/*
 *@Author:  Rick Goldberg
 *@Author:  Doug Gehringer
 */
package org.jdesktop.j3d.loaders.vrml97.impl;

/**  Description of the Class */
public class ConstMFVec3f extends ConstMField {

    /**
     *Constructor for the ConstMFVec3f object
     *
     *@param  owner Description of the Parameter
     */
    ConstMFVec3f(MFVec3f owner) {
        super(owner);
    }

    /**
     *Constructor for the ConstMFVec3f object
     *
     *@param  values Description of the Parameter
     */
    public ConstMFVec3f(float[][] values) {
        super(new MFVec3f(values));
    }

    /**
     *Constructor for the ConstMFVec3f object
     *
     *@param  size Description of the Parameter
     *@param  values Description of the Parameter
     */
    public ConstMFVec3f(int size, float[] values) {
        super(new MFVec3f(size, values));
    }


    /**
     *  Gets the value attribute of the ConstMFVec3f object
     *
     *@param  values Description of the Parameter
     */
    public void getValue(float[][] values) {
        ((MFVec3f) ownerField).getValue(values);
    }

    /**
     *  Gets the value attribute of the ConstMFVec3f object
     *
     *@param  values Description of the Parameter
     */
    public void getValue(float[] values) {
        ((MFVec3f) ownerField).getValue(values);
    }

    /**
     *  Description of the Method
     *
     *@param  index Description of the Parameter
     *@param  values Description of the Parameter
     */
    public void get1Value(int index, float[] values) {
        ((MFVec3f) ownerField).get1Value(index, values);
    }

    /**
     *  Description of the Method
     *
     *@param  index Description of the Parameter
     *@param  vec Description of the Parameter
     */
    public void get1Value(int index, SFVec3f vec) {
        ((MFVec3f) ownerField).get1Value(index, vec);
    }

    /**
     *  Description of the Method
     *
     *@return  Description of the Return Value
     */
    public synchronized Object clone() {
        return new ConstMFVec3f((MFVec3f) ownerField);
    }

    /**
     *  Description of the Method
     *
     *@return  Description of the Return Value
     */
    public a3vrml.Field wrap() {
        return new a3vrml.field.ConstMFVec3f(this);
    }
}

