package a3test.sound;

import jp.sourceforge.acerola3d.a3.*;
import javax.vecmath.*;

public class A3SoundsTest {
    public static void main(String args[]) throws Exception {
        A3Window w = new A3Window(300,300);
        A3Sounds s = new A3Sounds();
        Vector3d offset = new Vector3d();
        Vector3d dir = new Vector3d(0.0,0.0,1.0);
        s.load("test1","x-rzip:x-res:///dog_cat.a3!/SDogE@11.wav","Point",1.0,true,offset,dir);
        s.load("test2","x-rzip:x-res:///dog_cat.a3!/CatE@11.wav","Cone",1.0,true,offset,dir);
        s.load("test3","x-rzip:x-res:///background7.a3!/se02-r02.t.mp3","Background",1.0,true,offset,dir);
        w.add(s);
        s.start("test1");
        for (double t=0.0;t<4.0*Math.PI;t+=0.1) {
            s.setLoc(10.0*Math.sin(t),0.0,0.0);
            Thread.sleep(100);
        }
        s.stop("test1");
        s.start("test2");
        for (double t=0.0;t<4.0*Math.PI;t+=0.1) {
            //s.setRot(0.0,t,0.0);
            s.setSoundDirection("test2",Math.sin(t),0.0,Math.cos(t));
            Thread.sleep(100);
        }
        s.stop("test2");
        s.start("test3");
    }
}
