package a3test.subcanvas;

import jp.sourceforge.acerola3d.a3.*;
import javax.swing.JFrame;
import java.awt.*;

public class A3SubCanvasLockedA3Test {
    public static void main(String args[]) throws Exception {
        //A3Canvas mainCanvas = A3Canvas.createA3Canvas(300,300);
        JA3Canvas mainCanvas = JA3Canvas.createJA3Canvas(300,300);

        //A3SubCanvas subCanvas = A3SubCanvas.createA3SubCanvas(300,300);
        JA3SubCanvas subCanvas = JA3SubCanvas.createJA3SubCanvas(300,300);

        JFrame f = new JFrame("A3SubCanvasLockedA3Test");
        f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        f.setLayout(new GridLayout(1,2));
        f.add(mainCanvas);
        f.add(subCanvas);
        f.pack();
        f.setVisible(true);

        mainCanvas.addA3SubCanvas(subCanvas);
        mainCanvas.setNavigationMode(A3CanvasInterface.NaviMode.EDIT);

        subCanvas.setCameraLoc(3.0,0.0,3.0);
        subCanvas.setCameraRot(0.0,Math.PI/4.0,0.0);

        Action3D a3 = new Action3D("x-res:///axis.a3");
        mainCanvas.add(a3);
        A3Text3D a3_2 = new A3Text3D("LockedA3");
        a3_2.setLoc(-0.23,0.28,-1.0);
        a3_2.setScale(0.04);
        a3_2.setLabelLoc(5.0,0.0);
        a3_2.setLabel("label");
        subCanvas.addLockedA3(a3_2);
        Thread.sleep(3000);
        subCanvas.delLockedA3(a3_2);
        Thread.sleep(3000);
        subCanvas.addLockedA3(a3_2);
    }
}
