package a3test.subcanvas;

import jp.sourceforge.acerola3d.a3.*;
import javax.swing.JFrame;
import java.awt.*;

public class JA3SubCanvasTest {
    public static void main(String args[]) throws Exception {
        JA3Canvas mainCanvas = JA3Canvas.createJA3Canvas(300,300);
        JA3SubCanvas subCanvas = JA3SubCanvas.createJA3SubCanvas(300,300);

        JFrame f = new JFrame("JA3SubCanvasTest");
        f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        f.setLayout(new GridLayout(1,2));
        f.add(mainCanvas);
        f.add(subCanvas);
        f.pack();
        f.setVisible(true);

        //以下のメソッドはmainCanvas(JA3Canvas)がVisibleになってからでないと
        //NullPointerExceptionを吐く点に注意。
        mainCanvas.setNavigationMode(A3CanvasInterface.NaviMode.EDIT);
        mainCanvas.addA3SubCanvas(subCanvas);
        Action3D a3 = new Action3D("x-res:///axis.a3");
        mainCanvas.add(a3);

        subCanvas.setCameraLoc(3.0,0.0,3.0);
        subCanvas.setCameraRot(0.0,Math.PI/4.0,0.0);
    }
}
