package jp.sourceforge.acerola3d.apng;

import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadataFormatImpl;

public class APNGMetadataFormat extends IIOMetadataFormatImpl {
    // Create a single instance of this class (singleton pattern)
    private static APNGMetadataFormat defaultInstance =
            new APNGMetadataFormat();

    // Make constructor private to enforce the singleton pattern
    private APNGMetadataFormat() {
        // Set the name of the root node
        // The root node has a single child node type that may repeat
        super("jp.sourceforge.acerola3d.apng.APNGMetadata_0.01",
              CHILD_POLICY_REPEAT);

        // Set up the "KeywordValuePair" node, which has no children
        addElement("KeywordValuePair",
                   "jp.sourceforge.acerola3d.apng.APNGMetadata_0.01",
                   CHILD_POLICY_EMPTY);

        // Set up attribute "keyword" which is a String that is required
        // and has no default value
        addAttribute("KeywordValuePair", "keyword", DATATYPE_STRING,
                     true, null);
        // Set up attribute "value" which is a String that is required
        // and has no default value
        addAttribute("KeywordValuePair", "value", DATATYPE_STRING,
                     true, null);
    }

    // Check for legal element name
    public boolean canNodeAppear(String elementName,
                                 ImageTypeSpecifier imageType) {
        return elementName.equals("KeywordValuePair");
    }

    // Return the singleton instance
    public static APNGMetadataFormat getDefaultInstance() {
        return defaultInstance;
    }
}
