package jp.sourceforge.acerola3d.apng;

import java.io.*;
import java.util.zip.CRC32;
import javax.imageio.stream.ImageInputStream;

public class Chunk {
    int length;
    byte[] type = new byte[4];
    String typeStr;
    byte[] data;
    long crc;

    public Chunk(ImageInputStream iis) throws IOException {
        length = iis.readInt();
        iis.readFully(type);
        typeStr = String.format("%c%c%c%c",
            (char)type[0],(char)type[1],(char)type[2],(char)type[3]);
        data = new byte[length];
        for (int i=0;i<length;i++) {
            data[i] = iis.readByte();
        }
        crc = 0xffffffffL & iis.readInt();
        crcCheck();
    }

    void crcCheck() {
        CRC32 c = new CRC32();
        c.update(type);
        c.update(data);
        if (crc!=c.getValue())
            System.out.println("CRC32:ERROR!");
    }

    public DataInputStream getDataInputStream() {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        BufferedInputStream bis = new BufferedInputStream(bais);
        DataInputStream dis = new DataInputStream(bis);
        return dis;
    }

    public String toString() {
        return "Chunk(type="+typeStr+",len="+length+")";
    }
}
