<?php
/**
 * Setup Adelie Framework
 * @package	Adelie
 * @copyright	Copyright (c) 2012, Adelie Development Team
 */
namespace Adelie;

final class SetupCli extends namespace\AbstractCli
{
	/**
	 * constructer
	 * @access	public
	 */
	public function __contruct ()
	{
		parent::__construct();
		$this->setLockMode(false);
		$this->setVerboseMode(false);
	}

	/**
	 * create directories
	 * @access	private
	 * @return	void
	 */
	private function createDir ()
	{
		echo " * Creating Directories\n";
		\clearstatcache();
		$dirs = array(
			namespace\DIR_CLI, namespace\DIR_CNF, namespace\DIR_CTL, namespace\DIR_DAO, namespace\DIR_LIB, namespace\DIR_TPL,
			namespace\DIR_DAT, namespace\DIR_LCK, namespace\DIR_LOG, namespace\DIR_SESS, namespace\DIR_TMP
		);
		foreach ($dirs as $dir) {
			if (\file_exists($dir)) {
				echo "   {$dir} already exists.\n";
			} else {
				if (\mkdir($dir, 0755, true)) {
					echo "   {$dir} is created.\n";
				} else {
					$msg = namespace\Error::get(namespace\Error::E_CREATE, $dir);
					throw new namespace\AdelieException($msg, namespace\Error::E_CREATE);
				}
			}
		}
		echo "\n";
	}

	/**
	 * create configuration files
	 * @access	private
	 * @return	void
	 * @todo	merge when update
	 */
	private function createConfig ()
	{
		// Adelie configuration file
		$path = namespace\DIR_CNF."/adelie.php";
		echo " * Creating the configuration file \"adelie.php\".\n";
		\clearstatcache();
		$yes = false;
		$exists = \file_exists($path);
		if ($exists) {
			$msg = "   \"{$path}\" already exists. Override?";
			$yes = $this->getYesNo($msg, false);
			if (!$yes) {
				$backup_path = \sprintf("%s/adelie.%d.php", namespace\DIR_CNF, \time());
				@\rename($path, $backup_path);
				\printf("   Renamed \"%s\" to \"%s\".\n", \basename($path), \basename($backup_path));
			}
		}
		$contents = \file_get_contents(\sprintf("phar://%s/etc/adelie.txt", namespace\PHAR));
		$contents = \str_replace("###LOGO_ID###", namespace\String::createToken(), $contents);
		\file_put_contents($path, $contents);
		require_once $path;
		echo "\n";

		// Database configuration file
		$path = \sprintf("%s/database.php", namespace\DIR_CNF);
		echo " * Creating the configuration file \"database.php\".\n";
		\clearstatcache();
		$yes = false;
		$exists = \file_exists($path);
		if ($exists) {
			$msg = "   \"{$path}\" already exists. Override?";
			$yes = $this->getYesNo($msg, false);
			if (!$yes) {
				$backup_path = \sprintf("%s/database.%d.php", namespace\DIR_CNF, \time());
				@\rename($path, $backup_path);
				\printf("   Renamed \"%s\" to \"%s\".\n", \basename($path), \basename($backup_path));
			}
		}
		$contents = \file_get_contents(\sprintf("phar://%s/etc/database.txt", namespace\PHAR));
		\file_put_contents($path, $contents);
		echo "\n";

		// User Configuration file
		$path = \sprintf("%s/config.php", namespace\DIR_CNF);
		echo " * Creating the configuration file \"config.php\".\n";
		\clearstatcache();
		$yes = false;
		$exists = \file_exists($path);
		if ($exists) {
			$msg = "   \"{$path}\" already exists. Override?";
			$yes = $this->getYesNo($msg, false);
			if (!$yes) {
				$backup_path = \sprintf("%s/config.%d.php", namespace\DIR_CNF, \time());
				@\rename($path, $backup_path);
				\printf("   Renamed \"%s\" to \"%s\".\n", \basename($path), \basename($backup_path));
			}
		}
		$contents = \file_get_contents(\sprintf("phar://%s/etc/config.txt", namespace\PHAR));
		$contents = \str_replace("###NAMESPACE###", "\\".__NAMESPACE__, $contents);
		\file_put_contents($path, $contents);
		echo "\n";
	}

	/**
	 * create a default controller
	 * @access	private
	 * @return	void
	 */
	private function createController ()
	{
		echo " * Creating the action controller file \"".namespace\DEFAULT_CONTROLLER."Controller.php\".\n";
		\clearstatcache();
		$path = \sprintf("%s/%sController.php", namespace\DIR_CTL, namespace\DEFAULT_CONTROLLER);
		$yes = false;
		$exists = \file_exists($path);
		if ($exists) {
			$msg = "   \"{$path}\" already exists. Override?";
			$yes = $this->getYesNo($msg, false);
			if (!$yes) {
				$backup_path = \sprintf("%s/%sContorller.%d.php", namespace\DIR_CTL, namespace\DEFAULT_CONTROLLER, \time());
				@\rename($path, $backup_path);
				\printf("   Renamed \"%s\" to \"%s\".\n", \basename($path), \basename($backup_path));
			}
		}
		$contents = \file_get_contents("phar://".namespace\PHAR."/etc/ControllerSkelton.txt");
		$searches = array("###DESCRIPTION###", "###CLASS_NAME###", "###ACTION_NAME###", "###NAMESPACE###");
		$replaces = array(namespace\DEFAULT_CONTROLLER." Controller", namespace\DEFAULT_CONTROLLER, namespace\DEFAULT_ACTION, "\\".__NAMESPACE__);
		$contents = \str_replace($searches, $replaces, $contents);
		\file_put_contents($path, $contents);
		echo "\n";
	}

	/**
	 * システムログファイル(SQLite)を生成
	 * @access	private
	 * @return	void
	 */
	private function createLog ()
	{
		echo " * Creating system log file \"adelie.sqlite\".\n";
		\clearstatcache();
		$path = \sprintf("%s/adelie.sqlite", namespace\DIR_LOG);
		$yes = false;
		$exists = \file_exists($path);
		if ($exists) {
			$msg = "   \"{$path}\" already exists. Override?";
			$yes = $this->getYesNo($msg, false);
			if (!$yes) {
				$backup_path = \sprintf("%s/adelie.%d.sqlite", namespace\DIR_LOG, \time());
				@\rename($path, $backup_path);
				\printf("   Renamed \"%s\" to \"%s\".\n", \basename($path), \basename($backup_path));
			}
		}
		\file_put_contents($path, \file_get_contents("phar://".namespace\PHAR."/etc/adelie.sqlite"));
		echo "\n";
	}

	/**
	 * get an input yes|no value (1 char).
	 * @access	private
	 * @param	string	$msg	message
	 * @param	boolean	$default	Y is a default if "true".
	 * @return	boolean	"true" is YES, "false" is NO.
	 */
	private function getYesNo ($msg, $default=false)
	{
		$default_msg = $default ? "[Y/n]" : "[y/N]";
		$msg = \sprintf("%s %s ", $msg, $default_msg);
		echo $msg;
		$ans = \file_get_contents("php://stdin", false, null, 0, 1);

		// Result
		if ($default) { // default value is YES
			$result = ($ans=="n") ? false : true;
		} else { // default value is NO
			$result = ($ans=="y") ? true : false;
		}

		if ($result) {
			echo "   You choise YES.\n";
			return true;
		} else {
			echo "   You choise NO.\n";
			return false;
		}
	}

	/**
	 * execution
	 * @access	public
	 * @return	void
	 */
	public function run ()
	{
		echo "\n";

		// create the directories
		$this->createDir();

		// create the configuration files
		$this->createConfig();

		// create the controller file
		$this->createController();

		// create the log file
		$this->createLog();
	}
}
