<?php
/**
 * Abstract CLI Class
 * @package	Adelie
 * @abstract
 * @copyright	Copyright (c) 2012, Adelie Development Team
 */
namespace Adelie;

abstract class AbstractCli
{
	private $verbose; // 饒舌モード
	private $lock; // ロックモード

	private $prog;
	private $params;

	/**
	 * コンストラクタ
	 * @access	public
	 */
	public function __construct ()
	{
		$this->setVerboseMode();
		$this->setLockMode();

		// パラメーター取得
		$this->params = $_SERVER["argv"];
		\array_shift($this->params);
		\array_shift($this->params);
		$tmp = \explode("\\", \get_class($this));
		$this->prog = \preg_replace("/(.+)Cli$/", "\\1", $tmp[count($tmp)-1]);
	}

	/**
	 * ロックモードを設定
	 * @access	protected
	 * @final
	 * @param	boolean	$verbose
	 * @return	void
	 */
	final protected function setVerboseMode ($verbose=true)
	{
		$this->verbose = ($verbose===true) ? true : false;
	}

	/**
	 * 饒舌モードを判定
	 * @access	public
	 * @final
	 * @return	boolean
	 */
	final public function isVerboseMode ()
	{
		return $this->verbose;
	}

	/**
	 * ロックモードを設定
	 * @access	protected
	 * @final
	 * @param	boolean	$lock
	 * @return	void
	 */
	final protected function setLockMode ($lock=true)
	{
		$this->lock_mode = ($lock===true) ? true : false;
	}

	/**
	 * ロックモードを判定
	 * @access	public
	 * @final
	 * @return	boolean
	 */
	final public function isLockMode ()
	{
		return $this->lock;
	}

	/**
	 * 引数を取得
	 * @access	protected
	 * @param	integer	$idx
	 * @return	string
	 */
	final protected function get ($idx)
	{
		return isset($this->params[$idx]) ? $this->params[$idx] : "";
	}

	/**
	 * 実行プログラム名を取得
	 * @access	public
	 * @return	string
	 */
	final public function getProgName ()
	{
		return $this->prog;
	}

	/**
	 * execute
	 * @access	public
	 * @return	void
	 */
	public function run ()
	{
		$msg = namespace\Error::get(namespace\Error::E_INHERIT, __CLASS__);
		throw new namespace\AdelieException($msg, namespace\Error::E_INHERIT);
	}

	/**
	 * 複製マジックメソッド
	 * @access		public
	 * @return		void
	 * @exception	\Adelie\AdelieException
	 */
	public function __clone ()
	{
		$msg = namespace\Error::get(namespace\Error::E_CLONING);
		throw new namespace\AdelieException($msg, namespace\Error::E_CLONING);
	}
}
