<?php
/**
 * Front Controller Class
 * @package	Adelie
 * @copyright	Copyright (c) 2012, Adelie Development Team
 */
namespace Adelie;

require_once \sprintf("phar://%s/core/Request.php", namespace\PHAR);
require_once \sprintf("phar://%s/core/Router.php", namespace\PHAR);
require_once \sprintf("phar://%s/core/Dispatcher.php", namespace\PHAR);

final class Adelie
{
	private static $running;

	/**
	 * Constructor
	 * @access	private
	 */
	private function __construct ()
	{
	}

	/**
	 * execute
	 * @access	public
	 * @static
	 * @param	string	$site_id
	 * @return	void
	 */
	public static function run ($site_id="")
	{
		// 多重起動防止
		if (self::$running===null) {
			self::$running = true;
		} else {
			return;
		}

		try {
			// load the user configuration file.
			$config = \strlen($site_id) ? "config_{$site_id}.php" : "config.php";
			$config = \sprintf("%s/%s", namespace\DIR_CNF, $config);
			if (\is_readable($config)) {
				require_once $config;
			} else {
				$msg = namespace\Error::get(namespace\Error::E_EXIST, $config);
				throw new namespace\AdelieException($msg, namespace\Error::E_EXIST);
			}

			// 通常処理
			$router = namespace\Router::getInstance(namespace\Request::getInstance($site_id));
			$response = namespace\Dispatcher::dispatch($router->route());
			$response->respond();
		} catch (\Exception $e) {
			try {
				// エラー処理
				$request->setController(namespace\Request::ERROR_CONTROLLER);
				$request->setAction(namespace\Request::DEFAULT_ACTION);
				$response = namespace\Dispatcher::dispatch($request, $e);
				$response->respond();
			} catch (\Exception $e) {
				// エラー処理で例外を正しく処理しなかった場合はバッファーを破棄して終了
				@\ob_end_clean();
			}
		}
	}
}
