/*
 * Decompiled with CFR 0.152.
 */
package net.y3n20u.aeszip;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AesCtrBlockCipherOutputStream
extends FilterOutputStream {
    public static final String CIPHER_MODE_AES_CTR = "AES/CTR/NoPadding";
    public static final String KEY_ALGORITHM = "AES";
    public static final byte[] INITIAL_IV = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int BLOCK_SIZE = 16;
    private static final int NONCE_SIZE = 8;
    private static final byte BYTE_HEX_FF = -1;
    private Cipher _cipher;
    private Key _encryptKey;
    private final byte[] _iv = new byte[16];
    private final byte[] _restBytes = new byte[16];
    private int _restBytesLength;

    public AesCtrBlockCipherOutputStream(OutputStream outputStream) {
        super(outputStream);
        try {
            this._cipher = Cipher.getInstance(CIPHER_MODE_AES_CTR);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new RuntimeException(noSuchPaddingException);
        }
    }

    public void init(byte[] byArray) {
        System.arraycopy(INITIAL_IV, 0, this._iv, 0, 16);
        this._encryptKey = new SecretKeySpec(byArray, KEY_ALGORITHM);
        this._restBytesLength = 0;
    }

    private void _initIvAndCipher() {
        IvParameterSpec ivParameterSpec = new IvParameterSpec(this._iv);
        try {
            this._cipher.init(1, this._encryptKey, ivParameterSpec);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new RuntimeException(invalidKeyException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new RuntimeException(invalidAlgorithmParameterException);
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this._restBytesLength > 0) {
            n3 = 16 - this._restBytesLength;
            if (n2 < n3) {
                System.arraycopy(byArray, n, this._restBytes, this._restBytesLength, n2);
                this._restBytesLength += n2;
                return;
            }
            byte[] byArray2 = new byte[16];
            System.arraycopy(this._restBytes, 0, byArray2, 0, this._restBytesLength);
            System.arraycopy(byArray, n, byArray2, this._restBytesLength, n3);
            this._encryptAndWriteBlock(byArray2, 0, 16);
            n += n3;
            n2 -= n3;
            this._restBytesLength = 0;
        }
        n3 = n;
        while (n3 + 16 <= n + n2) {
            this._encryptAndWriteBlock(byArray, n3, 16);
            n3 += 16;
        }
        int n4 = n + n2 - n3;
        if (n4 > 0) {
            this._restBytesLength = n4;
            System.arraycopy(byArray, n3, this._restBytes, 0, n4);
        }
    }

    private void _encryptAndWriteBlock(byte[] byArray, int n, int n2) throws IOException {
        try {
            this._incrementIv();
            this._initIvAndCipher();
            byte[] byArray2 = this._cipher.doFinal(byArray, n, n2);
            this.out.write(byArray2, 0, byArray2.length);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            illegalBlockSizeException.printStackTrace();
        }
        catch (BadPaddingException badPaddingException) {
            badPaddingException.printStackTrace();
        }
    }

    private void _incrementIv() {
        for (int i = 0; i < 8; ++i) {
            if (this._iv[i] != -1) {
                int n = i;
                this._iv[n] = (byte)(this._iv[n] + 1);
                return;
            }
            this._iv[i] = 0;
        }
        throw new IllegalStateException();
    }

    @Override
    public void flush() throws IOException {
        if (this._restBytesLength > 0) {
            this._encryptAndWriteBlock(this._restBytes, 0, this._restBytesLength);
            this._restBytesLength = 0;
        }
        this.out.flush();
    }
}

