package net.y3n20u.aeszip;

import static net.y3n20u.aeszip.CommonValues.FILE_NAME_SEPARATOR;
import static net.y3n20u.aeszip.CommonValues.METHOD_DEFLATED;
import static net.y3n20u.aeszip.CommonValues.PASSWORD_ENCODING;
import static net.y3n20u.aeszip.CommonValues.ZIP_EXTENTION_WITH_PERIOD;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Date;

public class AesZipRecursiveEncrypter {
	public static int METHOD_DEFAULT = METHOD_DEFLATED;
	
	private static final int BUFFER_SIZE = 16384;

	private File _destination;
	private URI _baseURI;
	private FileFilter _fileFilter;
	
	public AesZipRecursiveEncrypter() {
		this(null);
	}

	public AesZipRecursiveEncrypter(File destination) {
		if (destination == null) {
			_destination = null;
		} else if (destination.isDirectory()) {
			// FIXME
			throw new IllegalArgumentException();
		} else {
			_destination = destination;
		}
	}
	
	public void setFileFilter(FileFilter fileFileter) {
		_fileFilter = fileFileter;
	}

	public void archive(File source, String password) {
		if (_destination == null) {
			_destination = new File(source.getParent(), source.getName() + ZIP_EXTENTION_WITH_PERIOD);
		}
		AesZipOutputStream zipOutputStream = null;
		try {
			zipOutputStream = new AesZipOutputStream(new FileOutputStream(_destination));
			_baseURI = source.getParentFile().toURI();
			this.archiveImpl(zipOutputStream, source, password.getBytes(PASSWORD_ENCODING));
		} catch (FileNotFoundException fnfe) {
			// FIXME
			fnfe.printStackTrace();
		} catch (UnsupportedEncodingException uee) {
			// FIXME: Auto-generated catch block
			uee.printStackTrace();
		} finally {
			try {
				if (zipOutputStream != null) {
					zipOutputStream.close();
				}
			} catch (IOException ioe) {
				// FIXME
				ioe.printStackTrace();
			}
		}
	}

	private void archiveImpl(AesZipOutputStream zipOut, File file, byte[] password) {
		if (_fileFilter != null && !_fileFilter.accept(file)) {
			return;
		}
		String entryName = _baseURI.relativize(file.toURI()).getPath();
		entryName += (file.isDirectory() && !entryName.endsWith(FILE_NAME_SEPARATOR))? FILE_NAME_SEPARATOR : "";
		AesZipEntry entry = new AesZipEntry(entryName, password);
		entry.setActualCompressionMethod(METHOD_DEFAULT);
		entry.setTime(new Date().getTime());
		try {
			zipOut.putNextZipEntry(entry);
		} catch (IOException ioe) {
			// FIXME Auto-generated catch block
			ioe.printStackTrace();
		}

		if (file.isDirectory()) {
			for (File f : file.listFiles()) {
				this.archiveImpl(zipOut, f, password);
			}
			return;
		}
		InputStream fileIn = null;
		try {
			fileIn = new BufferedInputStream(new FileInputStream(file));
			byte[] buf = new byte[BUFFER_SIZE];
			int size = fileIn.read(buf, 0, BUFFER_SIZE);
			while (size != -1) {
				zipOut.write(buf, 0, size);
				size = fileIn.read(buf, 0, BUFFER_SIZE);
			}
		} catch (FileNotFoundException fnfe) {
			// FIXME
			fnfe.printStackTrace();
		} catch (IOException ioe) {
			// FIXME
			ioe.printStackTrace();
		} finally {
			try {
				if (fileIn != null) {
					fileIn.close();
				}
			} catch (IOException ioe) {
				// FIXME
				ioe.printStackTrace();
			}
		}
	}
}
