package net.y3n20u.rfc2898;

/**
 * An interface for underlying pseudo-random function used in {@link Pbkdf2}.
 * @author y3n20u@gmail.com
 */
public interface PseudorandomFunction {

	/**
	 * hLen in RFC2898
	 * @return the length in octets of this pseudorandom function.
	 */
	int getLengthOfOutput();
	
	/**
	 * derive a pseudo-random value from parameters.
	 * the length of output equals to hLen.
	 * @param p P in RFC2898. password, an octet string.
	 * @param u 
	 * @return a pseudorandom value derived from the parameters.
	 */
	byte[] getPseudorandomBytes(byte[] p, byte[] u);
}
