/*
 * Decompiled with CFR 0.152.
 */
package net.y3n20u.aeszip;

import java.io.ByteArrayOutputStream;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.zip.ZipEntry;
import net.y3n20u.aeszip.CommonValues;
import net.y3n20u.aeszip.EncryptionStrengthMode;
import net.y3n20u.aeszip.InvalidFieldException;
import net.y3n20u.aeszip.InvalidMethodException;
import net.y3n20u.aeszip.PasswordNotCorrectException;
import net.y3n20u.rfc2898.Pbkdf2;
import net.y3n20u.util.ByteHelper;

public class AesZipEntry
extends ZipEntry {
    private static final byte[] AES_EXTRA_BYTES = ByteHelper.getBytes("01 99 07 00 02 00 41 45");
    private static final String MESSAGE_SIZE_WRONG = "size is too big or too small: {0}";
    private final EncryptionStrengthMode encryptionStrengthMode;
    private final byte[] saltValue;
    private byte[] encryptionKey;
    private byte[] authenticationKey;
    private byte[] passwordVerificationValue;
    private int method = 99;
    private long relativeOffsetOfLocalFileHeader;
    private boolean derivedKeys = false;

    public AesZipEntry(String string) {
        this(string, CommonValues.DEFAULT_ENCRYPT_STRENGTH_MODE);
    }

    public AesZipEntry(String string, EncryptionStrengthMode encryptionStrengthMode) {
        super(string);
        this.encryptionStrengthMode = encryptionStrengthMode;
        this.saltValue = AesZipEntry.generateSaltValue(this.encryptionStrengthMode.getSaltLength());
    }

    public AesZipEntry(String string, byte[] byArray) {
        this(string, CommonValues.DEFAULT_ENCRYPT_STRENGTH_MODE, byArray);
    }

    public AesZipEntry(String string, EncryptionStrengthMode encryptionStrengthMode, byte[] byArray) {
        this(string, encryptionStrengthMode);
        this.deriveKeys(byArray);
    }

    public void deriveKeys(byte[] byArray) {
        int n = this.encryptionStrengthMode.getKeyLength() + this.encryptionStrengthMode.getKeyLength() + 2;
        byte[] byArray2 = new Pbkdf2().deriveKey(byArray, this.saltValue, 1000, n);
        this.encryptionKey = new byte[this.encryptionStrengthMode.getKeyLength()];
        System.arraycopy(byArray2, 0, this.encryptionKey, 0, this.encryptionKey.length);
        this.authenticationKey = new byte[this.encryptionStrengthMode.getKeyLength()];
        System.arraycopy(byArray2, this.encryptionKey.length, this.authenticationKey, 0, this.authenticationKey.length);
        this.passwordVerificationValue = new byte[2];
        System.arraycopy(byArray2, this.encryptionKey.length + this.authenticationKey.length, this.passwordVerificationValue, 0, this.passwordVerificationValue.length);
        this.derivedKeys = true;
    }

    public void deriveKeys(byte[] byArray, byte[] byArray2, byte[] byArray3) throws PasswordNotCorrectException {
        int n = this.encryptionStrengthMode.getKeyLength() + this.encryptionStrengthMode.getKeyLength() + 2;
        byte[] byArray4 = new Pbkdf2().deriveKey(byArray, byArray2, 1000, n);
        this.encryptionKey = new byte[this.encryptionStrengthMode.getKeyLength()];
        System.arraycopy(byArray4, 0, this.encryptionKey, 0, this.encryptionKey.length);
        this.authenticationKey = new byte[this.encryptionStrengthMode.getKeyLength()];
        System.arraycopy(byArray4, this.encryptionKey.length, this.authenticationKey, 0, this.authenticationKey.length);
        this.passwordVerificationValue = new byte[2];
        System.arraycopy(byArray4, this.encryptionKey.length + this.authenticationKey.length, this.passwordVerificationValue, 0, this.passwordVerificationValue.length);
        if (!Arrays.equals(byArray3, this.passwordVerificationValue)) {
            throw new PasswordNotCorrectException(this.getName());
        }
        this.derivedKeys = true;
    }

    public void setContentCompressedSize(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        long l2 = l + (long)this.encryptionStrengthMode.getSaltLength() + 2L + 10L;
        if (l2 > 0xFFFFFFFFL || l2 < 0L) {
            throw new InvalidFieldException(MessageFormat.format(MESSAGE_SIZE_WRONG, l2));
        }
        super.setCompressedSize(l2);
    }

    public long getContentCompressedSize() {
        long l = super.getCompressedSize();
        if (this.isDirectory()) {
            return 0L;
        }
        if (l < 0L) {
            return -1L;
        }
        long l2 = l - (long)this.encryptionStrengthMode.getSaltLength() - 2L - 10L;
        if (l2 > 0xFFFFFFFFL || l2 < 0L) {
            throw new InvalidFieldException(MessageFormat.format(MESSAGE_SIZE_WRONG, l2));
        }
        return l2;
    }

    @Override
    public void setMethod(int n) {
        if (n != 99 && n != 0) {
            throw new IllegalArgumentException(new InvalidMethodException((short)n));
        }
        this.method = n;
    }

    @Override
    public int getMethod() {
        return this.method;
    }

    @Override
    public byte[] getExtra() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = super.getExtra();
        if (byArray != null) {
            byteArrayOutputStream.write(byArray, 0, byArray.length);
        }
        if (this.getMethod() != 99) {
            return byteArrayOutputStream.toByteArray();
        }
        byteArrayOutputStream.write(AES_EXTRA_BYTES, 0, AES_EXTRA_BYTES.length);
        byteArrayOutputStream.write(this.getStrengthMode().getModeValue());
        short s = this.getActualCompressionMethod();
        byteArrayOutputStream.write((byte)(s & 0xFF));
        byteArrayOutputStream.write((byte)(s >>> 8 & 0xFF));
        return byteArrayOutputStream.toByteArray();
    }

    public void setActualCompressionMethod(int n) {
        short s = (short)n;
        if (s != 0 && s != 8) {
            throw new InvalidMethodException(s);
        }
        super.setMethod(n);
    }

    public short getActualCompressionMethod() {
        return (short)super.getMethod();
    }

    public void setRelativeOffsetOfLocalFileHeader(long l) {
        if (l < 0L || l > 0xFFFFFFFFL) {
            throw new IllegalArgumentException(MessageFormat.format("the offset must be in [0, {1}], but the argument is {0}.", l, 0xFFFFFFFFL));
        }
        this.relativeOffsetOfLocalFileHeader = l;
    }

    public long getRelativeOffsetOfLocalFileHeader() {
        return this.relativeOffsetOfLocalFileHeader;
    }

    public short getLastModTime() {
        return AesZipEntry.generateTime(super.getTime());
    }

    public short getLastModDate() {
        return AesZipEntry.generateDate(super.getTime());
    }

    public EncryptionStrengthMode getStrengthMode() {
        return this.encryptionStrengthMode;
    }

    public byte[] getSaltValue() {
        return this.saltValue;
    }

    public byte[] getEncryptionKey() {
        if (this.derivedKeys) {
            return this.encryptionKey;
        }
        throw new IllegalStateException();
    }

    public byte[] getAuthenticationKey() {
        if (this.derivedKeys) {
            return this.authenticationKey;
        }
        throw new IllegalStateException();
    }

    public byte[] getPasswordVerificationValue() {
        if (this.derivedKeys) {
            return this.passwordVerificationValue;
        }
        throw new IllegalStateException();
    }

    private static byte[] generateSaltValue(int n) {
        byte[] byArray = new byte[n];
        new SecureRandom().nextBytes(byArray);
        return byArray;
    }

    private static short generateTime(long l) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        if (calendar.get(1) < 1980) {
            return 0;
        }
        int n = calendar.get(11);
        int n2 = calendar.get(12);
        int n3 = calendar.get(13);
        return (short)(n << 11 | n2 << 5 | n3 >> 1);
    }

    private static short generateDate(long l) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        int n = calendar.get(1);
        int n2 = calendar.get(2);
        int n3 = calendar.get(5);
        if (n < 1980) {
            n = 1980;
            n2 = 1;
            n3 = 1;
        }
        return (short)(n - 1980 << 9 | n2 + 1 << 5 | n3);
    }
}

