/*
 * Decompiled with CFR 0.152.
 */
package net.y3n20u.aeszip;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.zip.CRC32;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.y3n20u.aeszip.AesZipRuntimeException;

public class MacFilterOutputStream
extends FilterOutputStream {
    private Mac authenticationMac;
    private CRC32 crc;

    public MacFilterOutputStream(OutputStream outputStream) {
        super(outputStream);
        try {
            this.authenticationMac = Mac.getInstance("HmacSHA1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AesZipRuntimeException(noSuchAlgorithmException);
        }
        this.crc = new CRC32();
    }

    public long getCrc() {
        return this.crc.getValue();
    }

    public byte[] getAuthenticationCode() {
        return Arrays.copyOf(this.authenticationMac.doFinal(), 10);
    }

    public void init(byte[] byArray) {
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "HmacSHA1");
        try {
            this.authenticationMac.init(secretKeySpec);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new AesZipRuntimeException(invalidKeyException);
        }
        this.crc.reset();
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
        this.crc.update(byArray, n, n2);
        this.authenticationMac.update(byArray, n, n2);
    }
}

