package net.y3n20u.aeszip;

import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.io.File;
import java.nio.charset.Charset;

import org.junit.Test;

public class AesZipEncrypterTest {

	private static final String FILE_NAME_ENCODING = "UTF-8";

	@Test
	public void testArchive() {
		String password = "password";
		
		String[] sourceFiles = {"abc", "パリの写真.jpg", "abc/abc.txt", "abc/aiueo.txt", "abc/def"};
		
		String srcBase = "./test/resource/";
		String encFileName = "./test/resource/abctest3.zip";
		String decBase = "./test/resource/out3/";
		String suffix = "in3/";
		
		File encDestination = new File(encFileName);
		File decDestination = new File(decBase);
		
		FileUtil.deleteRecursive(encDestination);
		FileUtil.deleteRecursive(decDestination);

		try {
			AesZipEncrypter enc = new AesZipEncrypter(encDestination);
			enc.setFileNameCharset(Charset.forName(FILE_NAME_ENCODING));
			for (String name: sourceFiles) {
				enc.add(name, new File(srcBase + suffix + name), password);
			}
			enc.archive();
			
			decDestination.mkdirs();
			new ExternalDecrypterImpl().decryptAndExtractFile(encDestination, decDestination, password);
			File f1 = new File(srcBase + suffix);
			File f2 = new File(decBase);
			System.out.println("checking file1: [" + f1.getCanonicalPath() + "],  file2: [" + f2.getCanonicalPath());
			assertTrue(FileUtil.compareFilesRecursive(f1, f2));
		} catch (Exception e) {
			e.printStackTrace();
			fail(e.getMessage());
		}
	}

}
