import java.text.MessageFormat;

import net.y3n20u.aeszip.ArchiveProgressListener;
import net.y3n20u.aeszip.ArchiveProgressStatus;


public class ProgressListenerSample implements ArchiveProgressListener {
	private long startTime;
	
	@Override
	public void start() {
		System.out.println("start archive.");
		startTime = System.currentTimeMillis();
	}

	@Override
	public void notifyStatus(ArchiveProgressStatus status) {
		System.out.println(MessageFormat.format("[{0}] to [{1}].", status.getProcessedSourceName(), status.getDestinationName()));
		System.out.print(MessageFormat.format("current {0}%, total {1}%.  ", status.getProgressPercentageCurrent(), status.getProgressPercentageTotal()));
		System.out.print(MessageFormat.format("count [{0} / {1}].  ", status.getProcessedElementCount(), status.getTotalElementCount()));
		System.out.print(MessageFormat.format("current [{0} / {1}].  ", status.getProcessedSizeCurrent(), status.getEstimatedSizeCurrent()));
		System.out.println(MessageFormat.format("total [{0} / {1}].", status.getProcessedSizeTotal(), status.getEstimatedSizeTotal()));
	}

	@Override
	public void finishedAll() {
		System.out.println("finished.");
		System.out.println(MessageFormat.format("total time: {0} msec.", System.currentTimeMillis() - startTime));
	}
}