package net.y3n20u.aeszip;

import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.io.File;
import java.nio.charset.Charset;

import org.junit.Test;

public class AesZipRecursiveEncrypterTest {

	private static final String FILE_NAME_ENCODING = "UTF-8";

	@Test
	public void testArchive() {
		String password = "password";
		
		String srcBase = "./test/resource/";
		String encFileName = "./test/resource/abctest.zip";
		String decBase = "./test/resource/out/";
		String suffix = "in/";
		
		File source = new File(srcBase + suffix);
		File encDestination = new File(encFileName);
		File decDestination = new File(decBase);
		File resultDestination = new File(decBase + suffix);
		
		FileUtil.deleteRecursive(encDestination);
		FileUtil.deleteRecursive(decDestination);

		try {
			AesZipRecursiveEncrypter enc = new AesZipRecursiveEncrypter(source, password, encDestination);
			enc.setFileNameCharset(Charset.forName(FILE_NAME_ENCODING));
			enc.archive();
			
			decDestination.mkdirs();
			new ExternalDecrypterImpl().decryptAndExtractFile(encDestination, decDestination, password);
			assertTrue(FileUtil.compareFilesRecursive(source, resultDestination));
		} catch (Exception e) {
			e.printStackTrace();
			fail(e.getMessage());
		}
	}

}
