/**
 * @file arabic.cpp
 * Implements Arabic encodings. This includes:
 * - ISO 8859-6:1999
 * - IBM425
 * - IBM864
 * - IBM1046
 * - IBM9056
 * - IBM9238
 * - IBM16804
 * - windows-1256
 * - <del>MacArabic</del>
 * @author exeal
 * @date 2007-2009, 2014
 */

#include <ascension/corelib/encoder.hpp>


namespace ascension {
	namespace encoding {
		namespace implementation {
			namespace sbcs {
				namespace {
					struct Installer {
						Installer() {
#ifndef ASCENSION_NO_STANDARD_ENCODINGS
							Encoder::registerFactory(std::make_shared<
								SingleByteEncoderFactory<
									ISO8859CompatibleCharWire<
										CharLine<0x00a0, 0xfffd, 0xfffd, 0xfffd, 0x00a4, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x060c, 0x00ad, 0xfffd, 0xfffd>,
										CharLine<0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x061b, 0xfffd, 0xfffd, 0xfffd, 0x061f>,
										CharLine<0xfffd, 0x0621, 0x0622, 0x0623, 0x0624, 0x0625, 0x0626, 0x0627, 0x0628, 0x0629, 0x062a, 0x062b, 0x062c, 0x062d, 0x062e, 0x062f>,
										CharLine<0x0630, 0x0631, 0x0632, 0x0633, 0x0634, 0x0635, 0x0636, 0x0637, 0x0638, 0x0639, 0x063a, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd>,
										CharLine<0x0640, 0x0641, 0x0642, 0x0643, 0x0644, 0x0645, 0x0646, 0x0647, 0x0648, 0x0649, 0x064a, 0x064b, 0x064c, 0x064d, 0x064e, 0x064f>,
										CharLine<0x0650, 0x0651, 0x0652, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd>
									>
								>
							>("ISO-8859-6", standard::ISO_8859_6, "Arabic (ISO 8859-6)",
								"iso-ir-127|ISO_8859-6|ECMA-114|ASMO-708|arabic|csISOLatinArabic"
								"\0ibm-1089|8859_6|cp1089|1089|windows-28596|ISO-8859-6-I|ISO-8859-6-E|ibm-1089_P100-1995", 0x1a));
#endif // !ASCENSION_NO_STANDARD_ENCODINGS

#ifndef ASCENSION_NO_PROPRIETARY_ENCODINGS
							Encoder::registerFactory(std::make_shared<
								SingleByteEncoderFactory<
									IBMPCCompatibleCharWire<
										CharLine<0x00b0, 0x00b7, 0x2219, 0x221a, 0x2592, 0x2500, 0x2502, 0x253c, 0x2524, 0x252c, 0x251c, 0x2534, 0x2510, 0x250c, 0x2514, 0x2518>,
										CharLine<0x03b2, 0x221e, 0x03c6, 0x00b1, 0x00bd, 0x00bc, 0x2248, 0x00ab, 0x00bb, 0xfef7, 0xfef8, 0xfffd, 0xfffd, 0xfefb, 0xfefc, 0x200b>,
										CharLine<0x00a0, 0x00ad, 0xfe82, 0x00a3, 0x00a4, 0xfe84, 0xfffd, 0xfffd, 0xfe8e, 0xfe8f, 0xfe95, 0xfe99, 0x060c, 0xfe9d, 0xfea1, 0xfea5>,
										CharLine<0x0660, 0x0661, 0x0662, 0x0663, 0x0664, 0x0665, 0x0666, 0x0667, 0x0668, 0x0669, 0xfed1, 0x061b, 0xfeb1, 0xfeb5, 0xfeb9, 0x061f>,
										CharLine<0x00a2, 0xfe80, 0xfe81, 0xfe83, 0xfe85, 0xfeca, 0xfe8b, 0xfe8d, 0xfe91, 0xfe93, 0xfe97, 0xfe9b, 0xfe9f, 0xfea3, 0xfea7, 0xfea9>,
										CharLine<0xfeab, 0xfead, 0xfeaf, 0xfeb3, 0xfeb7, 0xfebb, 0xfebf, 0xfec3, 0xfec7, 0xfecb, 0xfecf, 0x00a6, 0x00ac, 0x00f7, 0x00d7, 0xfec9>,
										CharLine<0x0640, 0xfed3, 0xfed7, 0xfedb, 0xfedf, 0xfee3, 0xfee7, 0xfeeb, 0xfeed, 0xfeef, 0xfef3, 0xfebd, 0xfecc, 0xfece, 0xfecd, 0xfee1>,
										CharLine<0xfe7d, 0xfe7c, 0xfee5, 0xfee9, 0xfeec, 0xfef0, 0xfef2, 0xfed0, 0xfed5, 0xfef5, 0xfef6, 0xfedd, 0xfed9, 0xfef1, 0x25a0, 0xfffd>
									>
								>
							>("IBM864", proprietary::IBM864, "Arabic (IBM864)", "cp864|csIBM864\0ibm-864|ibm-864_X110-1999", 0x7f));

							Encoder::registerFactory(std::make_shared<
								SingleByteEncoderFactory<
									CharWire<
										CharLine<0x0000, 0x0001, 0x0002, 0x0003, 0x009c, 0x0009, 0x0086, 0x007f, 0x0097, 0x008d, 0x008e, 0x000b, 0x000c, 0x000d, 0x000e, 0x000f>,
										CharLine<0x0010, 0x0011, 0x0012, 0x0013, 0x009d, 0x0085, 0x0008, 0x0087, 0x0018, 0x0019, 0x0092, 0x008f, 0x001c, 0x001d, 0x001e, 0x001f>,
										CharLine<0x0080, 0x0081, 0x0082, 0x0083, 0x0084, 0x000a, 0x0017, 0x001b, 0x0088, 0x0089, 0x008a, 0x008b, 0x008c, 0x0005, 0x0006, 0x0007>,
										CharLine<0x0090, 0x0091, 0x0016, 0x0093, 0x0094, 0x0095, 0x0096, 0x0004, 0x0098, 0x0099, 0x009a, 0x009b, 0x0014, 0x0015, 0x009e, 0x001a>,
										CharLine<0x0020, 0x00a0, 0x0651, 0xfe7d, 0x0640, 0x200b, 0x0621, 0x0622, 0xfe82, 0x0623, 0x00a2, 0x002e, 0x003c, 0x0028, 0x002b, 0x007c>,
										CharLine<0x0026, 0xfe84, 0x0624, 0xfffd, 0xfffd, 0x0626, 0x0627, 0xfe8e, 0x0628, 0xfe91, 0x0021, 0x0024, 0x002a, 0x0029, 0x003b, 0x00ac>,
										CharLine<0x002d, 0x002f, 0x0629, 0x062a, 0xfe97, 0x062b, 0xfe9b, 0x062c, 0xfe9f, 0x062d, 0x00a6, 0x002c, 0x0025, 0x005f, 0x003e, 0x003f>,
										CharLine<0xfea3, 0x062e, 0xfea7, 0x062f, 0x0630, 0x0631, 0x0632, 0x0633, 0xfeb3, 0x060c, 0x003a, 0x0023, 0x0040, 0x0027, 0x003d, 0x0022>,
										CharLine<0x0634, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 0x0068, 0x0069, 0xfeb7, 0x0635, 0xfebb, 0x0636, 0xfebf, 0x0637>,
										CharLine<0x0638, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 0x0070, 0x0071, 0x0072, 0x0639, 0xfeca, 0xfecb, 0xfecc, 0x063a, 0xfece>,
										CharLine<0xfecf, 0x00f7, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 0x0078, 0x0079, 0x007a, 0xfed0, 0x0641, 0xfed3, 0x0642, 0xfed7, 0x0643>,
										CharLine<0xfedb, 0x0644, 0xfef5, 0xfef6, 0xfef7, 0xfef8, 0xfffd, 0xfffd, 0xfefb, 0xfefc, 0xfedf, 0x0645, 0xfee3, 0x0646, 0xfee7, 0x0647>,
										CharLine<0x061b, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048, 0x0049, 0x00ad, 0xfeeb, 0xfffd, 0xfeec, 0xfffd, 0x0648>,
										CharLine<0x061f, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 0x0050, 0x0051, 0x0052, 0x0649, 0xfef0, 0x064a, 0xfef2, 0xfef3, 0x0660>,
										CharLine<0x00d7, 0x2007, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058, 0x0059, 0x005a, 0x0661, 0x0662, 0xfffd, 0x0663, 0x0664, 0x0665>,
										CharLine<0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038, 0x0039, 0x20ac, 0x0666, 0x0667, 0x0668, 0x0669, 0x009f>
									>
								>
							>("IBM16804", MIB_OTHER, "Arabic (IBM16804 (IBM420 + Euro))", "ibm-16804|ibm-16804_X110-1999", 0x3f));

							Encoder::registerFactory(std::make_shared<
								SingleByteEncoderFactory<
									ASCIICompatibleCharWire<
										CharLine<0x20ac, 0x067e, 0x201a, 0x0192, 0x201e, 0x2026, 0x2020, 0x2021, 0x02c6, 0x2030, 0x0679, 0x2039, 0x0152, 0x0686, 0x0698, 0x0688>,
										CharLine<0x06af, 0x2018, 0x2019, 0x201c, 0x201d, 0x2022, 0x2013, 0x2014, 0x06a9, 0x2122, 0x0691, 0x203a, 0x0153, 0x200c, 0x200d, 0x06ba>,
										CharLine<0x00a0, 0x060c, 0x00a2, 0x00a3, 0x00a4, 0x00a5, 0x00a6, 0x00a7, 0x00a8, 0x00a9, 0x06be, 0x00ab, 0x00ac, 0x00ad, 0x00ae, 0x00af>,
										CharLine<0x00b0, 0x00b1, 0x00b2, 0x00b3, 0x00b4, 0x00b5, 0x00b6, 0x00b7, 0x00b8, 0x00b9, 0x061b, 0x00bb, 0x00bc, 0x00bd, 0x00be, 0x061f>,
										CharLine<0x06c1, 0x0621, 0x0622, 0x0623, 0x0624, 0x0625, 0x0626, 0x0627, 0x0628, 0x0629, 0x062a, 0x062b, 0x062c, 0x062d, 0x062e, 0x062f>,
										CharLine<0x0630, 0x0631, 0x0632, 0x0633, 0x0634, 0x0635, 0x0636, 0x00d7, 0x0637, 0x0638, 0x0639, 0x063a, 0x0640, 0x0641, 0x0642, 0x0643>,
										CharLine<0x00e0, 0x0644, 0x00e2, 0x0645, 0x0646, 0x0647, 0x0648, 0x00e7, 0x00e8, 0x00e9, 0x00ea, 0x00eb, 0x0649, 0x064a, 0x00ee, 0x00ef>,
										CharLine<0x064b, 0x064c, 0x064d, 0x064e, 0x00f4, 0x064f, 0x0650, 0x00f7, 0x0651, 0x00f9, 0x0652, 0x00fb, 0x00fc, 0x200e, 0x200f, 0x06d2>
									>
								>
							>("windows-1256", proprietary::WINDOWS_1256, "Arabic (windows-1256)", "\0cp1256|ibm-9448|ibm-9448_X100-2005", 0x3f));
#endif // !ASCENSION_NO_PROPRIETARY_ENCODINGS

#ifndef ASCENSION_NO_MINORITY_ENCODINGS
							Encoder::registerFactory(std::make_shared<
								sbcs::SingleByteEncoderFactory<
									CharWire<
										CharLine<0x0000, 0x0001, 0x0002, 0x0003, 0x009c, 0x0009, 0x0086, 0x007f, 0x0097, 0x008d, 0x008e, 0x000b, 0x000c, 0x000d, 0x000e, 0x000f>,
										CharLine<0x0010, 0x0011, 0x0012, 0x0013, 0x009d, 0x0085, 0x0008, 0x0087, 0x0018, 0x0019, 0x0092, 0x008f, 0x001c, 0x001d, 0x001e, 0x001f>,
										CharLine<0x0080, 0x0081, 0x0082, 0x0083, 0x0084, 0x000a, 0x0017, 0x001b, 0x0088, 0x0089, 0x008a, 0x008b, 0x008c, 0x0005, 0x0006, 0x0007>,
										CharLine<0x0090, 0x0091, 0x0016, 0x0093, 0x0094, 0x0095, 0x0096, 0x0004, 0x0098, 0x0099, 0x009a, 0x009b, 0x0014, 0x0015, 0x009e, 0x001a>,
										CharLine<0x0020, 0x00a0, 0x00e2, 0x060c, 0x00e0, 0x061b, 0x0640, 0x061f, 0x00e7, 0x0621, 0x0622, 0x002e, 0x003c, 0x0028, 0x002b, 0x007c>,
										CharLine<0x0026, 0x00e9, 0x00ea, 0x00eb, 0x00e8, 0x0623, 0x00ee, 0x00ef, 0x0624, 0x0625, 0x0021, 0x0024, 0x002a, 0x0029, 0x003b, 0x005e>,
										CharLine<0x002d, 0x002f, 0x00c2, 0x0626, 0x00c0, 0x0627, 0x0628, 0x0629, 0x00c7, 0x062a, 0x062b, 0x002c, 0x0025, 0x005f, 0x003e, 0x003f>,
										CharLine<0x062c, 0x00c9, 0x00ca, 0x00cb, 0x00c8, 0x062d, 0x00ce, 0x00cf, 0x062e, 0x0060, 0x003a, 0x0023, 0x0040, 0x0027, 0x003d, 0x0022>,
										CharLine<0x062f, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 0x0068, 0x0069, 0x00ab, 0x00bb, 0x0630, 0x0631, 0x0632, 0x0633>,
										CharLine<0x0634, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 0x0070, 0x0071, 0x0072, 0x0635, 0x0636, 0x00e6, 0x0637, 0x00c6, 0x20ac>,
										CharLine<0x00b5, 0x007e, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 0x0078, 0x0079, 0x007a, 0x0638, 0x0639, 0x063a, 0x005b, 0x0641, 0x0642>,
										CharLine<0x0643, 0x0644, 0x0645, 0x0646, 0x00a9, 0x00a7, 0x0647, 0x0152, 0x0153, 0x0178, 0x0648, 0x0649, 0x064a, 0x005d, 0x064b, 0x00d7>,
										CharLine<0x007b, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048, 0x0049, 0x00ad, 0x00f4, 0x064c, 0x064d, 0x064e, 0x064f>,
										CharLine<0x007d, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 0x0050, 0x0051, 0x0052, 0x0650, 0x00fb, 0x00fc, 0x00f9, 0x0651, 0x00ff>,
										CharLine<0x005c, 0x00f7, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058, 0x0059, 0x005a, 0x0652, 0x00d4, 0x200c, 0x200d, 0x200e, 0x200f>,
										CharLine<0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038, 0x0039, 0xfffd, 0x00db, 0x00dc, 0x00d9, 0x00a4, 0x009f>
									>
								>
							>("IBM425", MIB_OTHER, "Arabic (IBM425)", "ibm-425|ibm-425_P101-2000", 0x3f));

							Encoder::registerFactory(std::make_shared<
								SingleByteEncoderFactory<
									ASCIICompatibleCharWire<
										CharLine<0xfe88, 0x00d7, 0x00f7, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfe71, 0x0088, 0x25a0, 0x2502, 0x2500, 0x2510, 0x250c, 0x2514, 0x2518>,
										CharLine<0xfe79, 0xfe7b, 0xfe7d, 0xfe7f, 0xfe77, 0xfe8a, 0xfef0, 0xfef3, 0xfef2, 0xfece, 0xfecf, 0xfed0, 0xfef6, 0xfef8, 0xfefa, 0xfefc>,
										CharLine<0x00a0, 0xfffd, 0xfffd, 0xfffd, 0x00a4, 0xfffd, 0xfe8b, 0xfe91, 0xfe97, 0xfe9b, 0xfe9f, 0xfea3, 0x060c, 0x00ad, 0xfea7, 0xfeb3>,
										CharLine<0x0660, 0x0661, 0x0662, 0x0663, 0x0664, 0x0665, 0x0666, 0x0667, 0x0668, 0x0669, 0xfeb7, 0x061b, 0xfebb, 0xfebf, 0xfeca, 0x061f>,
										CharLine<0xfecb, 0x0621, 0x0622, 0x0623, 0x0624, 0x0625, 0x0626, 0x0627, 0x0628, 0x0629, 0x062a, 0x062b, 0x062c, 0x062d, 0x062e, 0x062f>,
										CharLine<0x0630, 0x0631, 0x0632, 0x0633, 0x0634, 0x0635, 0x0636, 0x0637, 0x0638, 0x0639, 0x063a, 0xfecc, 0xfe82, 0xfe84, 0xfe8e, 0xfed3>,
										CharLine<0x0640, 0x0641, 0x0642, 0x0643, 0x0644, 0x0645, 0x0646, 0x0647, 0x0648, 0x0649, 0x064a, 0x064b, 0x064c, 0x064d, 0x064e, 0x064f>,
										CharLine<0x0650, 0x0651, 0x0652, 0xfed7, 0xfedb, 0xfedf, 0x200b, 0xfef5, 0xfef7, 0xfef9, 0xfefb, 0xfee3, 0xfee7, 0xfeec, 0xfee9, 0xfffd>
									>
								>
							>("IBM1046", MIB_OTHER, "Arabic (IBM1046)", "ibm-1046|ibm-1046_X110-1999", 0x1a));

							Encoder::registerFactory(std::make_shared<
								SingleByteEncoderFactory<
									IBMPCCompatibleCharWire<
										CharLine<0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd>,
										CharLine<0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd>,
										CharLine<0x00a0, 0x00ad, 0xfffd, 0x00a3, 0x00a4, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x060c, 0xfffd, 0xfffd, 0xfffd>,
										CharLine<0x0660, 0x0661, 0x0662, 0x0663, 0x0664, 0x0665, 0x0666, 0x0667, 0x0668, 0x0669, 0xfffd, 0x061b, 0xfffd, 0xfffd, 0xfffd, 0x061f>,
										CharLine<0x00a2, 0x0621, 0x0622, 0x0623, 0x0624, 0xfffd, 0x0626, 0x0627, 0x0628, 0x0629, 0x062a, 0x062b, 0x062c, 0x062d, 0x062e, 0x062f>,
										CharLine<0x0630, 0x0631, 0x0632, 0x0633, 0x0634, 0x0635, 0x0636, 0x0637, 0x0638, 0x0639, 0x063a, 0x00a6, 0x00ac, 0x00f7, 0x00d7, 0xfffd>,
										CharLine<0x0640, 0x0641, 0x0642, 0x0643, 0x0644, 0x0645, 0x0646, 0x0647, 0x0648, 0x0649, 0x064a, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd>,
										CharLine<0xfffd, 0x0651, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd>
									>
								>
							>("IBM9056", MIB_OTHER, "Arabic (IBM9056)", "ibm-9056|ibm-9056_P100-1995", 0x7f));

							Encoder::registerFactory(std::make_shared<
								SingleByteEncoderFactory<
									ASCIICompatibleCharWire<
										CharLine<0xfe88, 0x00d7, 0x00f7, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfe71, 0x0088, 0x25a0, 0x2502, 0x2500, 0x2510, 0x250c, 0x2514, 0x2518>,
										CharLine<0xfe79, 0xfe7b, 0xfe7d, 0xfe7f, 0xfe77, 0xfe8a, 0xfef0, 0xfef3, 0xfef2, 0xfece, 0xfecf, 0xfed0, 0xfef6, 0xfef8, 0xfefa, 0xfefc>,
										CharLine<0x00a0, 0xfffd, 0xfffd, 0xfffd, 0x00a4, 0xfffd, 0xfe8b, 0xfe91, 0xfe97, 0xfe9b, 0xfe9f, 0xfea3, 0x060c, 0x00ad, 0xfea7, 0xfeb3>,
										CharLine<0x0660, 0x0661, 0x0662, 0x0663, 0x0664, 0x0665, 0x0666, 0x0667, 0x0668, 0x0669, 0xfeb7, 0x061b, 0xfebb, 0xfebf, 0xfeca, 0x061f>,
										CharLine<0xfecb, 0x0621, 0x0622, 0x0623, 0x0624, 0x0625, 0x0626, 0x0627, 0x0628, 0x0629, 0x062a, 0x062b, 0x062c, 0x062d, 0x062e, 0x062f>,
										CharLine<0x0630, 0x0631, 0x0632, 0x0633, 0x0634, 0x0635, 0x0636, 0x0637, 0x0638, 0x0639, 0x063a, 0xfecc, 0xfe82, 0xfe84, 0xfe8e, 0xfed3>,
										CharLine<0x0640, 0x0641, 0x0642, 0x0643, 0x0644, 0x0645, 0x0646, 0x0647, 0x0648, 0x0649, 0x064a, 0x064b, 0x064c, 0x064d, 0x064e, 0x064f>,
										CharLine<0x0650, 0x0651, 0x0652, 0xfed7, 0xfedb, 0xfedf, 0x200b, 0xfef5, 0xfef7, 0xfef9, 0xfefb, 0xfee3, 0xfee7, 0xfeec, 0xfee9, 0x20ac>
									>
								>
							>("IBM9238", MIB_OTHER, "Arabic (IBM9238)", "ibm-9238|ibm-9238_X110-1999", 0x1a));
#endif // !ASCENSION_NO_MINORITY_ENCODINGS
						}
					} installer;
				}
			}
		}
	}
}
