/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altBase.cpp 1398 2008-10-20 17:23:23Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altBase.cpp
 * \brief   Base Class
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include "altBase.h"
#include "altBaseMem.h"

/*----------------------------------------------------------------*
 * Function Implements
 *----------------------------------------------------------------*/
///
/// \brief  Constructor
///
LIBALT_API altBase::altBase()
{
}

///
/// \brief  Destructor
///
LIBALT_API altBase::~altBase()
{
}

///
/// \brief  new operator
///
/// \param  nSize [I ] memory size
///
/// \return pointer of memory
///
LIBALT_API void * altBase::operator new(altUInt nSize)
{
  altChar * pPtr = NULL;
  ALT_BASE_MALLOC (pPtr, nSize);
  return ((void *)pPtr);
}

///
/// \brief  delete operator
///
/// \param  pPtr  [I ] pointer of memory
///
LIBALT_API void altBase::operator delete(void * pPtr)
{
  altChar * p = (altChar *)pPtr;
  ALT_BASE_FREE (p);
}

///
/// \brief  new operator
///
/// \param  nSize       [I ] memory size
/// \param  szFileName  [I ] file name
/// \param  nLine       [I ] line numnber
///
/// \return pointer of memory
///
LIBALT_API void * altBase::operator new(altUInt nSize, const altChar * szFileName, const altUInt nLine)
{
  altChar * pPtr = NULL;
  altBaseMalloc (pPtr, nSize, szFileName, nLine);
  return ((void *)pPtr);
}

///
/// \brief  delete operator
///
/// \param  pPtr        [I ] pointer of memory
/// \param  szFileName  [I ] file name
/// \param  nLine       [I ] line numnber
///
LIBALT_API void altBase::operator delete(void * pPtr, const altChar * szFileName, const altUInt nLine)
{
  altChar * p = (altChar *)pPtr;
  altBaseFree (p, szFileName, nLine);
}

#if 0
LIBALT_API void ::exit(int c)
{
  _exit (c);
}
#endif
