#ifndef ALTBASE_H
#define ALTBASE_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altBase.h 1398 2008-10-20 17:23:23Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altBase.h
 * \brief   Base Class
 * \date    2007
 * \author  NEKO SYSTEM
 */

/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altCommon.h>

/*----------------------------------------------------------------*
 * Define
 *----------------------------------------------------------------*/
#define ALT_NEW new (__FILE__, __LINE__)

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  base class
///
class altBase
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altBase();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altBase();

  ///
  /// \brief  new operator
  ///
  /// \param  nSize [I ] memory size
  ///
  /// \return pointer of memory
  ///
  LIBALT_API void * operator new(altUInt nSize);

  ///
  /// \brief  delete operator
  ///
  /// \param  pPtr  [I ] pointer of memory
  ///
  LIBALT_API void operator delete(void * pPtr);

  ///
  /// \brief  new operator
  ///
  /// \param  nSize       [I ] memory size
  /// \param  szFileName  [I ] file name
  /// \param  nLine       [I ] line numnber
  ///
  /// \return pointer of memory
  ///
  LIBALT_API void * operator new(altUInt nSize, const altChar * szFileName, const altUInt nLine);

  ///
  /// \brief  delete operator
  ///
  /// \param  pPtr        [I ] pointer of memory
  /// \param  szFileName  [I ] file name
  /// \param  nLine       [I ] line numnber
  ///
  LIBALT_API void operator delete(void * pPtr, const altChar * szFileName, const altUInt nLine);
};


//LIBALT_API void ::exit(int c);

#endif

