/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id$

  Copyright (C) 2008 NEKO SYSTEM
 
 *---------------------------------------------------------------------------*/
/**
 * \file    altBaseKey.cpp
 * \brief   Base Key Class
 * \date    2008
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include "altBaseKey.h"
#include "altNet/altNetUtil.h"

/*----------------------------------------------------------------*
 * Define
 *----------------------------------------------------------------*/
#define ALT_KEY_FILE_NAME   "alt.key"
#define ALT_DECODE_KEY      "faslbaslknbalkafladfkeiowq"

/*----------------------------------------------------------------*
 * Function Implements
 *----------------------------------------------------------------*/
///
/// \brief  Constructor
///
LIBALT_API altBaseKey::altBaseKey()
{
}

///
/// \brief  Destructor
///
LIBALT_API altBaseKey::~altBaseKey()
{
}

///
/// \brief  Create Key File
///
/// \return ALT_S_SUCCESS success
/// \return ALT_E_ERROR   error
///
LIBALT_API alt_t altBaseKey::CreateKeyFile()
{
  alt_t status;
  m_oKeyFile.SetBool ("FIRST_BOOT", true);
  status = m_oKeyFile.EncodeSave (ALT_KEY_FILE_NAME, (const altByte *)ALT_DECODE_KEY, strlen (ALT_DECODE_KEY));
  ALT_ERR_RET (status);
  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Create Property File
///
/// \return ALT_S_SUCCESS   success
/// \return ALT_E_ERROR     error
///
LIBALT_API alt_t altBaseKey::Create()
{
  alt_t   status;
  altStr  sKey;
  altBool bFirstBoot = false;

  status = m_oKeyFile.DecodeLoad (ALT_KEY_FILE_NAME, (const altByte *)ALT_DECODE_KEY, strlen (ALT_DECODE_KEY));
  ALT_ERR_RET (status);

  bFirstBoot = m_oKeyFile.GetBool ("FIRST_BOOT");

  if (bFirstBoot) {
    status = altNetUtil::GetMacAddress (sKey);
    ALT_ERR_RET (status);

    status = m_oKeyFile.SetStr ("KEY", sKey);
    ALT_ERR_RET (status);

    status = m_oKeyFile.SetBool ("FIRST_BOOT", false);
    ALT_ERR_RET (status);

    status = m_oKeyFile.EncodeSave (ALT_KEY_FILE_NAME, (const altByte *)ALT_DECODE_KEY, strlen (ALT_DECODE_KEY));
    ALT_ERR_RET (status);
  }

  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Load Property File
///
/// \return ALT_S_SUCCESS   success
/// \return ALT_E_KEY_FILE  error
///
LIBALT_API alt_t altBaseKey::DecodeLoad()
{
  alt_t   status;
  altStr  sKey;
  
  status = m_oKeyFile.DecodeLoad (ALT_KEY_FILE_NAME, (const altByte *)ALT_DECODE_KEY, strlen (ALT_DECODE_KEY));
  ALT_ERR_RET (status);

  status = altNetUtil::GetMacAddress (sKey);
  ALT_ERR_RET (status);

  altStr  sFileKey = m_oKeyFile.GetStr ("KEY");
  if (sFileKey != sKey) {
    ALT_RET (ALT_E_KEY_FILE);
  }

  ALT_RET (ALT_S_SUCCESS);
}
